<?php

namespace App\Filament\Widgets;

use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Filament\Widgets\ChartWidget;

class BloggerPerformanceChart extends ChartWidget
{

    protected static ?string $heading = 'Chart';

    protected static bool $isDiscovered = false;

    protected function getData(): array
    {
        $id= request('id');
        $pending_orders= NewOrderProcessDetail::where('vendor_id',$id)->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER,NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])->count();
        $completed_orders= NewOrderProcessDetail::where('vendor_id',$id)->whereIn('status',[NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED])->count();
        return [
            'datasets' => [
                [
                    'label' => '# of Orders',
                    'data' => [$pending_orders,$completed_orders],
                    "borderWidth" => 0,
                    "backgroundColor"=> ['#b91c1c','#a16207'],
                ],
            ],
            "labels" => ["Pending Orders","Total Orders"],
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
