<?php

namespace App\Filament\Team\Widgets;

use App\Filament\Team\Resources\CompletedOrdersResource;
use App\Filament\Team\Resources\OrderAddedNotificationsResource;
use App\Filament\Team\Resources\RejectedLinksResource;

use App\Filament\Team\Resources\TicketResource;
use App\Models\Thread;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Support\Facades\Auth;

class TeamStatsWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected static bool $isDiscovered = false;
    protected function getStats(): array
    {
        return [
            Stat::make("Completed Orders",team_completed_orders())
                ->url(CompletedOrdersResource::getUrl())
            ,
            Stat::make("Order Added Notifications",team_order_added_notification())->url(OrderAddedNotificationsResource::getUrl()),
            Stat::make("Rejected Notifications",team_rejected_links())->url(RejectedLinksResource::getUrl()),
            Stat::make("Threads",Thread::where('owner_id', Auth::id())->orWhere('user_id',Auth::id())->count())->url(TicketResource::getUrl()),
        ];
    }
}
