<?php

namespace App\Filament\Team\Resources;

use App\Filament\Team\Resources\OrderAddedNotificationsResource\Pages;
use App\Filament\Team\Resources\OrderAddedNotificationsResource\RelationManagers;
use App\Models\NewOrder;
use App\Models\OrderAddedNotifications;
use App\Project\NewOrderStatus;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Facades\Auth;

class OrderAddedNotificationsResource extends Resource
{
    protected static ?string $model = NewOrder::class;
    protected static ?string $label = "Order Added Notifications";

    protected static ?string $navigationIcon = 'heroicon-o-book-open';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function getNavigationBadge(): ?string
    {
        return team_order_added_notification();
    }


    public static function table(Table $table): Table
    {
        return $table
            ->striped()
            ->query(
                NewOrder::where('team_id',Auth::id())
                    ->where('new_order_status',NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM)

            )
            ->defaultSort('created_at', 'desc')
            ->recordUrl(null)
            ->columns([
                Tables\Columns\TextColumn::make('order_id')->label("Order Id"),
                Tables\Columns\TextColumn::make('order_type')->toggleable()->sortable()->label("Order Type"),
                Tables\Columns\TextColumn::make('category')->toggleable()->badge(),
                Tables\Columns\TextColumn::make('client_name')->toggleable()->label("Client Name"),
                Tables\Columns\TextColumn::make('client_website')->toggleable()->label("Client Website"),
                Tables\Columns\TextColumn::make('no_of_links')->toggleable()->sortable()->label("No of Links"),
                Tables\Columns\TextColumn::make('order_package')->toggleable()->label("Order Package"),
            ])
            ->filters([
                //
            ])
            ->actions([
//                Tables\Actions\EditAction::make(),
                Tables\Actions\Action::make('push_to_manager')->icon("heroicon-o-arrow-top-right-on-square")->label(" ")->tooltip("Push To Manager")->url(function (NewOrder $record) {
                    return OrderAddedNotificationsResource::getUrl('push_to_manager', ['record' => $record->id]);
                })
            ])
            ->bulkActions([

            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOrderAddedNotifications::route('/'),
            'create' => Pages\CreateOrderAddedNotifications::route('/create'),
            'edit' => Pages\EditOrderAddedNotifications::route('/{record}/edit'),
            'push_to_manager' => Pages\PushToManager::route('/push_to_manager/{record}'),
        ];
    }
}
