<?php

namespace App\Filament\Team\Resources\CompletedOrdersResource\Pages;

use App\Filament\Team\Resources\CompletedOrdersResource;
use App\Models\NewOrder;
use Filament\Resources\Pages\Page;
use Illuminate\Contracts\View\View;

class OrderDetailPage extends Page
{
    public $record;
    protected static string $resource = CompletedOrdersResource::class;

    protected static string $view = 'filament.team.resources.completed-orders-resource.pages.order-detail-page';

    public function render(): View
    {
        $order= NewOrder::with("new_order_processes.new_order_process_details")->where('id',$this->record)->first();
        return parent::render()->with("order",$order);
    }
}
