<?php

namespace App\Filament\Resources\TeamMemberResource\Pages;

use App\Filament\Resources\TeamMemberResource;
use App\Models\User;
use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;

class CreateTeamMember extends CreateRecord
{
    protected static string $resource = TeamMemberResource::class;
    protected ?string $heading = "Add Team Member";

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }


    protected function handleRecordCreation(array $data): Model
    {
        $user= new User();
        $user->name= $data['name'];
        $user->email= $data['email'];
        $user->role = $data['role'];
        $user->password= bcrypt($data['password']);
        $user->save();
        Notification::make("suc")->title("Team Member Added")->success()->send();
        return $user;
    }


}
