<?php

namespace App\Filament\Resources\PendingBulkUploadRequestsResource\Pages;

use App\Filament\Resources\PendingBulkUploadRequestsResource;
use App\Models\NewSite;
use Carbon\Carbon;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Infolists\Components\Actions;
use Filament\Infolists\Components\Actions\Action;
use Filament\Infolists\Components\TextEntry;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\Page;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Support\HtmlString;
use PHPUnit\Exception;

class ViewBulkUploadedSites extends Page implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    public $record;

    protected static string $resource = PendingBulkUploadRequestsResource::class;

    protected static string $view = 'filament.resources.pending-bulk-upload-requests-resource.pages.view-bulk-uploaded-sites';


    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewSite::withCount("dupl")
                    ->with("new_order_process_detail")
                    ->where('bulk_upload_id',$this->record)

            )
            ->columns([
                TextColumn::make('root_domain')->label("Root Domain")
                    ->formatStateUsing(function (NewSite $record){
                        if(Carbon::parse($record->created_at)->diffInDays(Carbon::now()) <= 30){
                            $text = "<span style='background: green;font-size: 11px;color: white;display: inline-block;margin-left: 3px;padding: 1px 7px;'>New Arrival</span>";
                        }else{
                            $text =  '';
                        }

                        return new HtmlString($record->root_domain. $text);
                    })->wrap()
                    ->description(function (NewSite $record) {
                        $text ='';
                        $text .= 'Category:- '.$record->category.'<br>';
                        $text .= 'Added on:- '.$record->created_at->toDayDateTimeString().'<br>';
                        if($record->new_order_process_detail){
                            $text .= 'Last Order Created :- '.Carbon::parse($record->new_order_process_detail->created_at)->toDayDateTimeString();
                        }

                        return new HtmlString('<span style="font-size: 12px;">'.$text.'</span>');
                    }),

                TextColumn::make("site_status")->label("Site Status")->formatStateUsing(function (NewSite $d) {
                    if($d->site_status == 0){
                        return new HtmlString('<span style="background: orange" class="bg-orange-500 text-white text-xs px-2 py-1">P</span>');
                    }elseif($d->site_status == 2) {
                        return new HtmlString('<span style="background: red" class="bg-red-500 text-white text-xs px-2 py-1" > R</span >');
                    }
                    elseif( $d->site_status == 1 ) {
                        return new HtmlString('<span style="background: green" class="bg-green-700 text-white text-xs px-2 py-1">A</span>');
                    }
                    return '';
                }),

                TextColumn::make('dr')->label("DR")->toggleable()->sortable(),
                TextColumn::make('da')->label("DA")->toggleable()->sortable(),
                TextColumn::make('rd')->label("RD")->toggleable()->sortable(),
                TextColumn::make('spam_score')->toggleable()->sortable(),

                TextColumn::make('traffic_source')->label("Traffic")->toggleable()->sortable(),
                TextColumn::make('gp_price')->label("GP Price")->toggleable()->sortable(),
                TextColumn::make('niche_edit_price')->label("Niche Price")->toggleable()->sortable(),
                TextColumn::make('fc_gp')->label("FC GP")->toggleable()->sortable(),
                TextColumn::make('fc_ne')->label("FC NE")->toggleable()->sortable(),
                TextColumn::make('website_status')->toggleable()->label("Website Status")->badge()->color(function (NewSite $d){
                    if($d->website_status == 'Acceptable'){
                        return 'success';
                    }
                    if($d->website_status == 'Non Acceptable'){
                        return 'danger';
                    }
                })->sortable(),
                TextColumn::make('email')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->formatStateUsing(function (NewSite $d) {
                        if(!empty($d->email)) {
                            return $d->email;
                        }else{
                            return optional($d->uploaded_user)->email;
                        }
                    }),
            ])
            ->filters([
                // ...
            ])
            ->actions([
                \Filament\Tables\Actions\Action::make("view")->icon("heroicon-m-eye")->label(" ")->tooltip("view")->infolist([
                    TextEntry::make("website_niche")->inlineLabel(),
                    TextEntry::make("sample_url")->inlineLabel(),
                    TextEntry::make("href_url")->formatStateUsing(function (NewSite $d) {
                        return new HtmlString('<span style="word-wrap: anywhere; ">'.$d->href_url.'</span>');
                    }),
                    TextEntry::make("paypal_id")->inlineLabel(),
                    TextEntry::make("skype")->inlineLabel(),
                    TextEntry::make("whatsapp")->inlineLabel(),
                    TextEntry::make("country_source")->inlineLabel(),

                ]),
            ])
            ->bulkActions([
                // ...
            ]);
    }

}
