<?php

namespace App\Filament\Resources\OrderResource\Pages;

use App\Filament\Resources\OrderResource;
use App\Models\NewOrder;
use App\Models\OrdersView;
use Filament\Resources\Pages\Page;
use Illuminate\Contracts\View\View;

class OrderDetail extends Page
{
    public $record;
    protected static string $resource = OrderResource::class;


    protected static string $view = 'filament.resources.order-resource.pages.order-detail';

    public function render(): View
    {
        $order= NewOrder::with("new_order_processes.new_order_process_details")->findOrFail($this->record);
        $view = OrdersView::where("id",$this->record)->first();
        return parent::render()->with("order",$order)->with("view",$view);
    }

    public static function shouldRegisterSpotlight(): bool
    {
        return false;
    }


}
