<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CountriesListResource\Pages;
use App\Filament\Resources\CountriesListResource\RelationManagers;
use App\Models\CountriesList;
use App\Models\Country;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class CountriesListResource extends Resource
{
    protected static ?string $model = Country::class;
    protected static ?string $label = "Countries List";

    protected static ?string $navigationGroup = "More Links";

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make("Add New Country")->schema([
                    Forms\Components\TextInput::make("name"),
                    Forms\Components\CheckboxList::make("payment_methods")->options([
                        "bank" => "Bank",
                        "paypal" => "Paypal ID",
                        "qr_code" => "QR Code",
                        "upi_id" => "UPI ID"
                    ])
               ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make("name"),
                Tables\Columns\TextColumn::make("payment_methods")->formatStateUsing(function (Country $record) {
                    return implode(", ", json_decode($record->payment_methods));
                }),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make()->label(" "),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCountriesLists::route('/'),
            'create' => Pages\CreateCountriesList::route('/create'),
            'edit' => Pages\EditCountriesList::route('/{record}/edit'),
        ];
    }
}
