<?php

namespace App\Filament\Pages;

use App\Models\WalletHistory;
use App\Models\WithdrawRequest;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;

class PaymentHistoryDetail extends Page implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;
    protected static bool $shouldRegisterNavigation = false;
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    public ?array $data = [];
    public $request;
    public $action;

    public $record;

    protected static string $view = 'filament.pages.payment-history-detail';

    public function mount(): void
    {

//        dd($this->action);
        $this->request = WithdrawRequest::with("wallet_histories","user","request_date","remarks_data")->find($this->record);

        $histories = WalletHistory::with("new_order_process_detail.new_order_process.new_order")
            ->whereIn('id',$this->request->wallet_histories->pluck('id')->toArray())->get();

        $this->form->fill([
            "remarks"   =>  $histories[0]->remarks
        ]);
    }


    public function render(): View
    {
        return parent::render(); // TODO: Change the autogenerated stub
    }

    public function table(Table $table): Table
    {
        return $table
            ->query(
                WalletHistory::with("new_order_process_detail.new_order_process.new_order")
                    ->whereIn('id',$this->request->wallet_histories->pluck('id')->toArray())
            )
            ->columns([
                TextColumn::make("created_at"),
                TextColumn::make("id")->label("Order Id")->formatStateUsing(function (WalletHistory $record) {
                    return optional(optional(optional($record->new_order_process_detail)->new_order_process)->new_order)->order_id;
                })->description(function (WalletHistory $record) {
                    return "URL:- ".optional($record->new_order_process_detail)->submit_url;
                }),
                TextColumn::make("price")

            ])
            ->filters([
                // ...
            ])
            ->actions([
                // ...
            ])
            ->bulkActions([
                // ...
            ]);
    }


    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Remarks")->schema([
                    Textarea::make("remarks")->label("")
                ])
            ])
            ->statePath('data');
    }

    public function create()
    {


//        dd("END");


        $data = $this->form->getState();


        if($this->action == "new") {
            $remarks = $data['remarks'];
            try {
                DB::beginTransaction();

                foreach ($this->request->wallet_histories as $history) {

                    $history->status = 1;
                    $history->approved_date = Carbon::now();
                    $history->remarks = $remarks;


                    $history->save();


                }
                $this->request->status = 1;

                if( $this->request->invoice_number ) {

                    $histories = WalletHistory::with("new_order_process_detail.new_order_process.new_order")
                        ->whereIn('id', $this->request->wallet_histories->pluck("id"))->get();

                    $pdf = Pdf::loadView('pdf', [
                        "record" => $this->request,
                        "histories" => $histories
                    ]);
                    $pdf->save(public_path() . '/invoices/' . $this->request->invoice_number . '.pdf');

                    $this->request->invoice_file = "/invoices/" . $this->request->invoice_number . ".pdf";
                }
                $this->request->save();
//             Mail::to($email)->send(new WithdrawalRequestApprovalMail($name,$invoice_id));
                DB::commit();
                Notification::make("success")->title("Payment Success")->send();
                return redirect(request()->header('Referer'));
            }catch (\Exception $exception){
                DB::rollBack();
                dd($exception->getMessage());
            }
        }
        else{
            $histories = WalletHistory::with("new_order_process_detail.new_order_process.new_order")
                ->whereIn('id', $this->request->wallet_histories->pluck('id')->toArray())->get();
            try {
                DB::beginTransaction();
                foreach ($histories as $history) {

                    $history->remarks = $data['remarks'];
                    $history->save();
                }

                DB::commit();

                Notification::make("success")->title("Success")->send();

                return redirect(request()->header('Referer'));
            } catch (\Exception $exception) {
                DB::rollBack();
            }
        }

    }

}
