<?php

namespace App\Filament\Pages;

use App\Harman\Helpers\CategoriesList;
use App\Harman\Helpers\CountriesList;
use App\Models\NewSite;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use PHPUnit\Exception;

class EditSite extends Page implements HasForms
{
    use InteractsWithForms;
    public $new_site;
    public ?array $data = [];

    public function mount(): void
    {
        $this->new_site = NewSite::find(request('id'));
//        dd($this->new_site);
        $this->form->fill([
            "site_id"       =>  $this->new_site->id,
            "root_domain"   =>  $this->new_site->root_domain,
            "category"      =>  $this->new_site->category,
            "website_niche" =>  $this->new_site->website_niche,
            "traffic_source" =>  $this->new_site->country_source,
            "spam_score"    =>  $this->new_site->spam_score,
            "sample_url"    =>  $this->new_site->sample_url,
            "website_status" =>  $this->new_site->website_status,
            "href_url"      =>  $this->new_site->href_url,
            "total_time"    =>  $this->new_site->total_time,
            "marked_sponsor" =>  $this->new_site->marked_sponsor,
            "grey_niche_types" =>  $this->new_site->grey_niche_types,
            "da"             =>  $this->new_site->da,
            "dr"             =>  $this->new_site->dr,
            "traffic"        =>  $this->new_site->traffic_source,
            "gp_price"       =>  $this->new_site->gp_price,
            "rd"             =>  $this->new_site->rd,
            "niche_edit_price"  =>  $this->new_site->niche_edit_price,
            "deal_cbd_casino"  =>  $this->new_site->deal_cbd_casino,
            "fc_gp"          =>  $this->new_site->fc_gp,
            "fc_ne"          =>  $this->new_site->fc_ne,
            "paypal_id"          =>  $this->new_site->paypal_id,
            "whatsapp"          =>  $this->new_site->whatsapp,
            "skype"          =>  $this->new_site->skype,

        ]);
    }

    protected static bool $shouldRegisterNavigation = false;
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.edit-site';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Domain Information")->schema([
                    Hidden::make("site_id"),
                    TextInput::make("root_domain"),
                    TextInput::make("category"),
                    TextInput::make("website_niche"),
                    TextInput::make("traffic_source"),
                    TextInput::make("spam_score")->numeric(),
                    TextInput::make("sample_url")->url(),
                    TextInput::make("website_status"),
                    TextInput::make("href_url"),
                    Select::make("total_time")->options([
                        "24"    =>  "24 Hours",
                        "48"    =>  "48 Hours",
                        "72"    =>  "72 Hours",
                    ])

                ])->columns(4),

                Section::make("Link Information")->schema([
                    Select::make("marked_sponsor")->options([
                        "Yes"    =>  "Yes",
                        "No"    =>  "No",
                    ]),

                   TextInput::make("grey_niche_types")
                ])->columns(4),


                Section::make("SEO Metrics")->schema([
                    TextInput::make("da")->label("DA")->numeric(),
                    TextInput::make("dr")->label("DR")->numeric(),
                    TextInput::make("traffic")->label("Traffic")->numeric(),
                    TextInput::make("gp_price")->label("GP Price (USD)")->numeric(),
                    TextInput::make("rd")->label("RD")->numeric(),
                    TextInput::make("niche_edit_price")->label("Niche Edit Price (USD)")->numeric(),
                    TextInput::make("deal_cbd_casino")->label("Deal CBD CASINO")->numeric(),
                    TextInput::make("fc_gp")->label("FC GP")->numeric(),
                    TextInput::make("fc_ne")->label("FC NE")->numeric(),
                ])->columns(4),

                Section::make("User Info")->schema([
                    TextInput::make("paypal_id"),
                    TextInput::make("whatsapp"),
                    TextInput::make("skype"),
                ])->columns(3)

            ])
            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();


//        dd($data);

//        dd($data['root_domain']);
        try{
            $new_site = NewSite::find($data['site_id']);

//            dd($new_site);
//            dd($new_site);
            $new_site->root_domain = $data['root_domain'];
            $new_site->category = $data['category'];
            $new_site->country_source = $data['traffic_source'];
            $new_site->spam_score = $data['spam_score'];
            $new_site->sample_url = $data['sample_url'];
            $new_site->website_status = $data['website_status'];
            $new_site->href_url = $data['href_url'];
            $new_site->total_time = $data['total_time'];

            $new_site->marked_sponsor = $data['marked_sponsor'];

            $new_site->da = $data['da'];
            $new_site->dr = $data['dr'];
            $new_site->rd = $data['rd'];
            $new_site->traffic_source =  $data['traffic'];

            $new_site->gp_price =  $data['gp_price'];

            $new_site->niche_edit_price = $data['niche_edit_price'];

            $new_site->deal_cbd_casino = $data['deal_cbd_casino'];
            $new_site->fc_gp = $data['fc_gp'];
            $new_site->fc_ne = $data['fc_ne'];

            $new_site->website_niche = $data['website_niche'];
            $new_site->paypal_id = $data['paypal_id'];
            $new_site->whatsapp = $data['whatsapp'];
            $new_site->skype = $data['skype'];
            $new_site->grey_niche_types = $data['grey_niche_types'];
            $new_site->save();

//            dd($this->new_site);

            Notification::make("success")->title("Site Info Updated")->send();

        }catch (Exception $exception){
            session()->flash("error",$exception->getMessage());
        }
    }


}
