<?php

namespace App\Filament\Pages;

use App\Models\NewSite;
use App\Models\User;
use Carbon\Carbon;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Infolists\Components\TextEntry;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;

class CreateAccountFromSites extends Page implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;
    protected static ?string $navigationGroup = "Sites";
    protected static ?string $navigationIcon = 'heroicon-o-user-plus';

    protected static string $view = 'filament.pages.create-account-from-sites';


    public function table(Table $table): Table
    {
        return $table
            ->headerActions([
                Action::make("create_account")
                    ->label('Create Accounts (default password is 12345678)')
                    ->color('success')
                    ->action(function (){
                        try{
                            DB::beginTransaction();
                            $sites= NewSite::where('uploaded_user_id',Auth::id())->where('site_status',1)->where('email','!=','')->get();

                            foreach ($sites as $site) {
                                $check= User::where('email',$site->email)->first();
                                if(!$check){
                                    $u= new User();
                                    $u->name= explode("@",$site->email)[0];
                                    $u->email= trim($site->email);
                                    $u->role= "vendor";
                                    $u->password= bcrypt("12345678");
                                    $u->save();

                                    $site->uploaded_user_id= $u->id;
                                    $site->save();
                                }else{
                                    $site->uploaded_user_id= $check->id;
                                    $site->save();
                                }
                            }

                            DB::commit();

                            Notification::make("success")->title("Accounts Created Successfully")->send();
                        }catch (\Exception $exception){
                            DB::rollBack();
                            dd($exception->getMessage());
                        }

                    }),
            ])
            ->query(
                NewSite::where('uploaded_user_id',Auth::id())->where('site_status',1)->where('email','!=','')
            )
            ->columns([

                TextColumn::make('email')

            ])
            ->filters([
                // ...
            ])
            ->actions([

            ])
            ->bulkActions([
                // ...
            ]);
    }

    public function post_create_account_from_sites(Request $request)
    {
        try{
            DB::beginTransaction();
            $sites= NewSite::where('uploaded_user_id',Auth::id())->where('site_status',1)->where('email','!=','')->get();

            foreach ($sites as $site) {
                $check= User::where('email',$site->email)->first();
                if(!$check){
                    $u= new User();
                    $u->name= explode("@",$site->email)[0];
                    $u->email= trim($site->email);
                    $u->role= "vendor";
                    $u->password= bcrypt("12345678");
                    $u->save();

                    $site->uploaded_user_id= $u->id;
                    $site->save();
                }else{
                    $site->uploaded_user_id= $check->id;
                    $site->save();
                }
            }

            DB::commit();

            return redirect()->back()->with("success","Accounts Created");
        }catch (\Exception $exception){
            DB::rollBack();
            return redirect()->back()->with("error",$exception->getMessage());
        }

    }

}
