<?php

namespace App\Filament\Manager\Widgets;

use App\Filament\Manager\Resources\PendingApprovalForTeamResource;
use App\Models\NewOrder;
use App\Models\NewOrderProcess;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Carbon\Carbon;
use Filament\Forms\Components\Textarea;
use Filament\Notifications\Notification;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TodayPendingApprovalsForTeamsWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected static bool $isDiscovered = false;

    protected int | string | array $columnSpan = 2;
    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrder::with("order_processes_team_pushed_to_manager.new_order_process_details")
                    ->whereHas("order_processes_team_pushed_to_manager",function ($q){
                        $q->whereDate('created_at',Carbon::today());
                    })
                    ->where('manager_id',Auth::id())
                    ->where('new_order_status',NewOrderStatus::$TEAM_PUSHED_TO_MANAGER)
            )
            ->columns([
                Tables\Columns\TextColumn::make("order_id"),
                Tables\Columns\TextColumn::make("client_name"),
                Tables\Columns\TextColumn::make("client_website"),
                Tables\Columns\TextColumn::make("no_of_links"),
                Tables\Columns\TextColumn::make("order_type"),
            ])  ->actions([
                Tables\Actions\Action::make("detail")->url(function (NewOrder $record) {
                    return PendingApprovalForTeamResource::getUrl('detail', ['record' => $record->id]);
                }),
                Tables\Actions\Action::make("post_disapproved")->form([
                    Textarea::make("note")->label("Note")
                ])->action(function (NewOrder $record, array $data) {
                    $order= NewOrder::with("order_processes_team_pushed_to_manager.new_order_process_details")
                        ->where('id',$record->id)
                        ->where('manager_id',Auth::id())
                        ->where('new_order_status',NewOrderStatus::$TEAM_PUSHED_TO_MANAGER)
                        ->first();

                    try{
                        DB::beginTransaction();

                        $status= NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM;

                        $new_order_process= new NewOrderProcess();
                        $new_order_process->new_order_id= $order->id;
                        $new_order_process->team_id= $order->team_id;
                        $new_order_process->manager_id= $order->manager_id;
                        $new_order_process->note = $data['note'];
                        $new_order_process->status= $status;
                        $new_order_process->save();

                        $order->new_order_status= $status;
                        $order->save();


                        foreach($order->order_processes_team_pushed_to_manager->new_order_process_details as $detail){

                            $dtl= new NewOrderProcessDetail();
                            $dtl->new_order_process_id = $new_order_process->id;
                            $dtl->new_site_id = $detail->new_site_id;
                            $dtl->url = $detail->url;
                            $dtl->price = $detail->price;
                            $dtl->new_note = $detail->new_note;
                            $dtl->save();


                        }


                        DB::commit();
                        Notification::make("success")->title("Post Disapproved")->send();

                    }catch (\Exception $exception){
                        DB::rollBack();
                        dd($exception->getMessage());
                    }
                })
            ]);
    }
}
