<?php

namespace App\Filament\Manager\Widgets;

use App\Filament\Manager\Resources\PendingApprovalForBloggersResource;
use App\Filament\Manager\Resources\PendingApprovalForTeamResource;
use App\Filament\Manager\Resources\PendingApprovalForWriterResource;
use App\Filament\Manager\Resources\RejectedOrdersFromBloggersResource;
use App\Filament\Manager\Resources\TicketResource;
use App\Models\Thread;
use Filament\Support\Enums\IconPosition;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Support\Facades\Auth;

class ManagerStatsWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected static bool $isDiscovered = false;
    protected function getStats(): array
    {
            return [

                Stat::make("Pending Approvals for Bloggers",manager_pending_approvals_for_bloggers())
                    ->icon("heroicon-o-users")
                    ->url(PendingApprovalForBloggersResource::getUrl()),

                Stat::make("Pending Approvals Teams",manager_pending_approvals_for_team())
                    ->icon("heroicon-o-bolt")
                    ->url(PendingApprovalForTeamResource::getUrl()),
                Stat::make("Pending Approvals Writers",manager_pending_approvals_for_writer())
                    ->icon("heroicon-o-building-office-2")
                    ->url(PendingApprovalForWriterResource::getUrl()),
                Stat::make("Rejected Orders Bloggers",bloggers_rejected_orders_for_manager())
                    ->icon("heroicon-o-users")
                    ->url(RejectedOrdersFromBloggersResource::getUrl()),
                Stat::make("Threads",Thread::where('owner_id', Auth::id())->orWhere('user_id',Auth::id())->count())
                    ->icon("heroicon-o-chat-bubble-left-right")
                    ->url(TicketResource::getUrl()),
            ];
    }
}
