<?php

namespace App\Filament\Manager\Resources\PendingApprovalForWriterResource\Pages;

use App\Filament\Manager\Resources\PendingApprovalForTeamResource;
use App\Filament\Manager\Resources\PendingApprovalForWriterResource;
use App\Models\EmailQueueList;
use App\Models\NewOrder;
use App\Models\NewOrderProcess;
use App\Models\NewOrderProcessDetail;
use App\Models\User;
use App\Project\NewOrderStatus;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Concerns\InteractsWithInfolists;
use Filament\Infolists\Contracts\HasInfolists;
use Filament\Infolists\Infolist;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\Page;
use Filament\Support\Enums\FontWeight;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;

class DetailPage extends Page implements HasForms, HasInfolists
{
    use InteractsWithForms;
    use InteractsWithInfolists;

    public ?array $data = [];

    public $record;
    public $order;

    protected static string $resource = PendingApprovalForWriterResource::class;

    protected static string $view = 'filament.manager.resources.pending-approval-for-writer-resource.pages.detail-page';

    public function mount(int | string $record): void
    {
        $this->order= NewOrder::with("order_processes_writer_pushed_to_manager.new_order_process_details")
            ->where('manager_id',Auth::id())
            ->where('new_order_status',NewOrderStatus::$WRITER_PUSHED_TO_MANAGER)
            ->where('id',$record)
            ->first();

        $data  = [];

        foreach($this->order->order_processes_writer_pushed_to_manager->new_order_process_details as $detail){
            $data[] = [
                "root_domain"   =>  $detail->new_site->root_domain,
                "price"   =>  $this->order->order_type == "gp" ? $detail->new_site->gp_price : $detail->new_site->niche_edit_price,
                "anchor"   =>  $detail->anchor,
                "url"   =>  $detail->ourl,
                "post_url"   =>  $detail->url,
                "title"   =>  $detail->title,
                "doc_urls"  =>  $detail->doc_urls,
                "note"  =>  $detail->note,
                "upload_doc_files"  =>  $detail->upload_doc_file ? $detail->upload_doc_file : "",
                "type"  =>  $detail->type,
                "insert_after"  =>  $detail->insert_after,
                "insert_statement"  =>  $detail->statement,

            ];
        }

        $this->form->fill(["details"    =>  $data]);
    }
    public function render(): View
    {
        return parent::render();
    }
    public function OrderInfolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->record($this->order)
            ->schema([
                Section::make("Order Details")->schema([
                    TextEntry::make("order_id")->label("Order ID")->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("no_of_links")->label("No of Links")->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("order_type")->label("Order Type")->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("order_processes_writer_pushed_to_manager.writer.name")->label("Writer")
                        ->formatStateUsing(function ($record){
                            return new HtmlString($record->order_processes_writer_pushed_to_manager->writer->name.'<br>'.$record->order_processes_writer_pushed_to_manager->writer->email);
                        })
                        ->columnSpan(2)
                        ->weight(FontWeight::Medium)->color('primary'),
                ])->columns(5)->collapsed()
            ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                \Filament\Forms\Components\Section::make("Push To Blogger")->schema([

                    Repeater::make("details")
                        ->label(" ")
                        ->addable(false)
                        ->orderable(false)
                        ->deletable(false)
                        ->extraItemActions([

                        ])
                        ->schema([

                            \Filament\Forms\Components\Section::make("Niche Order")
                                ->aside()
                                ->hidden(function (){
                                    if($this->order->order_type == "gp"){
                                        return true;
                                    }

                                    return false;
                                })
                                ->schema([
                                Placeholder::make("root_domain")
                                    ->inlineLabel()->content(function (Get $get){
                                        return $get('root_domain');
                                    }),
                                Placeholder::make("anchor")
                                    ->inlineLabel()->content(function (Get $get){
                                        return $get('anchor');
                                    }),
                                Placeholder::make("url")
                                    ->inlineLabel()->content(function (Get $get){
                                        return $get('url');
                                    }),
                                Placeholder::make("post_url")
                                    ->inlineLabel()->content(function (Get $get){
                                        return $get('post_url');
                                    }),
                                Placeholder::make("price")
                                    ->inlineLabel()->content(function (Get $get){
                                        return $get('price');
                                    }),

                                Placeholder::make("type")
                                    ->label(function (Get $get){
                                        if( $get('type') == 'replace' ){
                                            return "Replace With";
                                        }
                                        return "Insert After";
                                    })
                                    ->inlineLabel()->content(function (Get $get){
                                        return new HtmlString($get('insert_after'));
                                    }),


                                Placeholder::make("type")
                                    ->label(function (Get $get){
                                        if( $get('type') == 'replace' ){
                                            return "Replace Statement";
                                        }
                                        return "Insert Statement";
                                    })
                                    ->inlineLabel()->content(function (Get $get){
                                        return new HtmlString($get('insert_statement'));
                                    }),

                                Placeholder::make("note")
                                    ->inlineLabel()->content(function (Get $get){
                                        return $get('note');
                                    }),

                            ]),




                            \Filament\Forms\Components\Section::make("GP Order")
                                ->aside()
                                ->hidden(function (){
                                    if($this->order->order_type == "niche"){
                                        return true;
                                    }

                                    return false;
                                })
                                ->schema([
                                    Placeholder::make("root_domain")
                                        ->inlineLabel()->content(function (Get $get){
                                            return $get('root_domain');
                                        }),
                                    Placeholder::make("price")
                                        ->inlineLabel()->content(function (Get $get){
                                            return $get('price');
                                        }),
                                    Placeholder::make("anchor")
                                        ->inlineLabel()->content(function (Get $get){
                                            return $get('anchor');
                                        }),

                                    Placeholder::make("title")
                                        ->inlineLabel()->content(function (Get $get){
                                            return $get('title');
                                        }),
                                    Placeholder::make("doc_urls")
                                        ->inlineLabel()->content(function (Get $get){
                                            return new HtmlString('<span style="word-wrap: break-word">'.$get('doc_urls').'</span>');
                                        }),
                                    Placeholder::make("upload_doc_files")->label("External Doc Files Url")
                                        ->inlineLabel()->content(function (Get $get){
                                            if(!empty($get('upload_doc_files'))) {
                                                return new HtmlString('<a href="' . url($get('upload_doc_files')) . '">Click to view</a>');
                                            }
                                            return "";
                                        }),
                                    Placeholder::make("note")
                                        ->inlineLabel()->content(function (Get $get){
                                            return $get('note');
                                        }),


                                ]),



                        ])
                ])
            ])

            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();
        $order = NewOrder::with("order_processes_writer_pushed_to_manager.new_order_process_details")
            ->where('manager_id', Auth::id())
            ->where('new_order_status', NewOrderStatus::$WRITER_PUSHED_TO_MANAGER)
            ->where('id', $this->record)->firstorFail();

        try {
            DB::beginTransaction();
            $order->new_order_status = NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER;
            $order->save();

            $process = new NewOrderProcess();
            $process->new_order_id = $order->id;
            $process->manager_id = Auth::id();
            $process->status = NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER;
            $process->save();

            foreach ($order->order_processes_writer_pushed_to_manager->new_order_process_details as $det) {
                $name= $det->new_site->uploaded_user->name;
                $email = $det->new_site->uploaded_user->email;

                $detail = new NewOrderProcessDetail();
                $detail->new_order_process_id = $process->id;
                $detail->new_site_id = $det->new_site_id;
                $detail->url = $det->url;
                $detail->price = $det->price;
                $detail->anchor = $det->anchor;
                $detail->ourl = $det->ourl;
                $detail->title = $det->title;
                $detail->doc_urls = $det->doc_urls;
                $detail->upload_doc_file = $det->upload_doc_file;
                $detail->insert_after = $det->insert_after;
                $detail->type = $det->type;
                $detail->statement = $det->statement;
                $detail->note = $det->note;
                $detail->vendor_id = $det->new_site->uploaded_user_id;
                $detail->status = NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER;
                $detail->save();

//                    Mail::to($email)->send(new OrderProceedingMsgMail($name,$order->order_id));


                $q= new EmailQueueList();
                $q->sender_email= $email;
                $q->sender_email_class= "App\Mail\OrderProceedingMsgMail";
                $q->parameters= "$name,$order->order_id";
                $q->status= 0;
                $q->user_id= Auth::user()->id;
                $q->save();


                $blogger= User::where('role','vendor')->where('id',$det->new_site->uploaded_user_id)->first();

                Notification::make()
                    ->title("New Order Pushed")
                    ->body("Order No: ".$order->order_id)
                    ->success()
                    ->sendToDatabase([$blogger]);

            }

            DB::commit();
            Notification::make("success")->title("Successfully Pushed to Bloggers")->send();
            $this->redirect(PendingApprovalForWriterResource::getUrl("index"));
        } catch (\Exception $exception) {

            DB::rollBack();
            dd($exception->getMessage());

        }
    }

}
