<?php

namespace App\Filament\Manager\Resources;

use App\Filament\Manager\Resources\PendingApprovalForTeamResource\Pages;
use App\Filament\Manager\Resources\PendingApprovalForTeamResource\RelationManagers;
use App\Models\NewOrder;
use App\Models\NewOrderProcess;
use App\Models\NewOrderProcessDetail;
use App\Models\PendingApprovalForTeam;
use App\Models\User;
use App\Project\NewOrderStatus;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use pxlrbt\FilamentExcel\Actions\Tables\ExportBulkAction;
use pxlrbt\FilamentExcel\Columns\Column;
use pxlrbt\FilamentExcel\Exports\ExcelExport;

class PendingApprovalForTeamResource extends Resource
{
    protected static ?string $model = NewOrder::class;
    protected static ?string $label = "Pending Approval For Team";

    protected static ?string $navigationGroup = "Pending Approval";

//    protected static ?string $recordTitleAttribute = 'order_id';
    protected static ?string $navigationLabel = "Teams";

    protected static ?string $navigationIcon = 'heroicon-o-bolt';


//    public static function getGlobalSearchResultUrl(Model $record): ?string
//    {
//        return NewOrderResource::getUrl('detail', ['record' => $record->id]);
//    }
    public static function getNavigationBadge(): ?string
    {
        return manager_pending_approvals_for_team();
    }


    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->recordUrl(null)
            ->defaultSort('created_at', 'desc')
            ->query(
                NewOrder::with("order_processes_team_pushed_to_manager.new_order_process_details")
                    ->where('manager_id',Auth::id())
                    ->where('new_order_status',NewOrderStatus::$TEAM_PUSHED_TO_MANAGER)
            )
            ->columns([
                Tables\Columns\TextColumn::make("order_id")->label("Order Id")->searchable()->sortable(),
                Tables\Columns\TextColumn::make("team.name")->toggleable()->label("Team")->description(function (NewOrder $record) {
                    return $record->team->email;
                })->sortable(),
                Tables\Columns\TextColumn::make("client_name")->toggleable()->label("Client Name")->searchable()->sortable(),
                Tables\Columns\TextColumn::make("client_website")
                    ->toggleable()
                    ->copyable()
                    ->icon("heroicon-o-document-duplicate")
                    ->tooltip("Click here to Copy")
                    ->label("Client Website")->searchable()->sortable(),
                Tables\Columns\TextColumn::make("no_of_links")->toggleable()->label("No of Links")->sortable(),
                Tables\Columns\TextColumn::make("order_type")->toggleable()->label("Order Type")->sortable()->badge()->color(function (NewOrder $record) {
                    if($record->order_type == "gp"){
                        return 'info';
                    }else{
                        return 'success';
                    }
                }),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\Action::make("detail")
                    ->label(" ")
                    ->icon("heroicon-o-eye")
                    ->color("success")
                    ->tooltip("View Details")
                    ->url(function (NewOrder $record) {
                    return PendingApprovalForTeamResource::getUrl('detail', ['record' => $record->id]);
                }),
                Tables\Actions\Action::make("post_disapproved")
                    ->label(" ")
                    ->color("danger")
                    ->icon("heroicon-o-trash")
                    ->tooltip("Post Disapproved")
                    ->form([
                    Forms\Components\Textarea::make("note")->label("Note")
                ])->action(function (NewOrder $record, array $data) {
                    $order= NewOrder::with("order_processes_team_pushed_to_manager.new_order_process_details")
                        ->where('id',$record->id)
                        ->where('manager_id',Auth::id())
                        ->where('new_order_status',NewOrderStatus::$TEAM_PUSHED_TO_MANAGER)
                        ->first();

                    try{
                        DB::beginTransaction();

                        $status= NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM;

                        $new_order_process= new NewOrderProcess();
                        $new_order_process->new_order_id= $order->id;
                        $new_order_process->team_id= $order->team_id;
                        $new_order_process->manager_id= $order->manager_id;
                        $new_order_process->note = $data['note'];
                        $new_order_process->status= $status;
                        $new_order_process->save();

                        $order->new_order_status= $status;
                        $order->save();


                        foreach($order->order_processes_team_pushed_to_manager->new_order_process_details as $detail){

                            $dtl= new NewOrderProcessDetail();
                            $dtl->new_order_process_id = $new_order_process->id;
                            $dtl->new_site_id = $detail->new_site_id;
                            $dtl->url = $detail->url;
                            $dtl->price = $detail->price;
                            $dtl->new_note = $detail->new_note;
                            $dtl->save();


                        }


                        DB::commit();
                        Notification::make("success")->title("Post Disapproved")->send();

                        $admin = admin_record();
                        $manager = User::where('role','team')->where('id',$record->team_id)->first();

                        Notification::make()->title("Order No. ".$record->order_id)
                            ->body("Order Rejected by ".Auth::user()->name.'('.Auth::user()->email.')')
                            ->success()
                            ->sendToDatabase([$admin,$manager]);

                    }catch (\Exception $exception){
                        DB::rollBack();
                        dd($exception->getMessage());
                    }
                })
            ])
            ->bulkActions([
                ExportBulkAction::make()->exports([
                    ExcelExport::make()->withColumns([
                        Column::make("order_id")->heading("Order Id"),
                        Column::make("team.name")->heading("Team Name"),
                        Column::make("team.email")->heading("Team Email"),
                        Column::make("client_name")->heading("Client Name"),
                        Column::make("client_website")->heading("Client Website"),
                        Column::make("no_of_links")->heading("No of Links"),
                        Column::make("order_type")->heading("Order Type"),

                    ])
                ])
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPendingApprovalForTeams::route('/'),
            'create' => Pages\CreatePendingApprovalForTeam::route('/create'),
            'edit' => Pages\EditPendingApprovalForTeam::route('/{record}/edit'),
            'detail'    =>  Pages\DetailPage::route("/{record}"),
        ];
    }
}
