<?php

namespace App\Filament\Manager\Resources\NewOrderResource\Pages;

use App\Filament\Manager\Resources\NewOrderResource;
use App\Models\NewOrder;
use Filament\Resources\Pages\Page;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;

class OrderDetail extends Page
{
    public $record;
    protected static string $resource = NewOrderResource::class;



    protected static string $view = 'filament.manager.resources.new-order-resource.pages.order-detail';


    public function render(): View
    {
        $order= NewOrder::with("new_order_processes.new_order_process_details")->where('manager_id',Auth::id())->findOrFail($this->record);
        return parent::render()->with("order",$order);
    }

    public static function shouldRegisterSpotlight(): bool
    {
        return false;
    }


}
