<?php

namespace App\Filament\Manager\Resources\NewOrderResource\Pages;

use App\Filament\Manager\Resources\NewOrderResource;
use App\Models\NewOrder;
use App\Models\OrdersView;
use App\Models\User;
use App\Project\NewOrderStatus;
use Filament\Actions;
use Filament\Forms\Components\Radio;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class EditNewOrder extends EditRecord
{
    protected static string $resource = NewOrderResource::class;



    protected function mutateFormDataBeforeFill(array $data): array
    {
        $data = NewOrder::find($data['id']);
        return $data->toArray();
    }


    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()->requiresConfirmation(),
        ];
    }

    protected function handleRecordUpdate(Model $record, array $data): Model
    {




        $r = NewOrder::find($record->id);
        $r->update($data);

        $team= User::where('role','team')->where('id',$r->team_id)->first();
        $admin = User::where('role','admin')->first();


        Notification::make()
            ->title("Order No. ".$r->order_id." Updated")
            ->body(" Updated by ".Auth::user()->name.'('.Auth::user()->email.')')
            ->success()
            ->sendToDatabase([$team,$admin]);
        return $r;
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    public function form(Form $form): Form
    {
        return $form

            ->schema([
                Section::make("Edit Order")
                    ->schema([

                        TextInput::make("client_name")->required(),

                        TextInput::make("client_website")->required(),


                        RichEditor::make("message")
                            ->required( )
                            ->columnSpanFull()





                    ])->columns(3)
            ]);
    }


}
