<?php

namespace App\Filament\Manager\Resources\NewOrderResource\Pages;

use App\Filament\Manager\Resources\NewOrderResource;
use App\Models\NewOrder;
use App\Models\User;
use App\Project\NewOrderStatus;
use Filament\Actions;
use Filament\Forms\Components\Livewire;
use Filament\Forms\Components\Radio;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\HtmlString;

class CreateNewOrder extends CreateRecord
{

    protected static string $resource = NewOrderResource::class;


    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['fc'] = $data['forgotton_category'];
        unset($data['forgotton_category']);
        $data['manager_id'] = auth()->user()->id;
        $data['new_order_status'] = NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM;
        return $data;
    }

    protected function handleRecordCreation(array $data): Model
    {
        $model = NewOrder::create($data);
        $team= User::where('role','team')->where('id',$data['team_id'])->first();
        $admin = User::where('role','admin')->first();

        Notification::make()
            ->title("New Order Created by ".Auth::user()->name.'('.Auth::user()->email.')')
            ->success()
            ->sendToDatabase([$team,$admin]);
        return $model;
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('create');
    }

    public function form(Form $form): Form
    {
        return $form

            ->schema([
                Section::make("Add New Order")
                    ->schema([
                        Select::make("type")->live()->label("Order Type")->options([
                            "new"    =>  "New Order",
                            "sub"    =>  "Sub Order"
                        ])->required(),
                        Select::make("team_id")->label("Select Team")
                            ->searchable()
                            ->options(User::where('role','team')->orderBy('name','asc')->pluck('name','id'))
                            ->required(),
                        TextInput::make("order_id")->label("Order ID")->required()
                            ->unique(ignoreRecord: true)->hidden(function (Get $get) {
                                if( empty($get('type')) ){
                                    return false;
                                }
                                if( $get('type') == 'new' ) {
                                    return false;
                                }
                                return true;
                            }),
                        TextInput::make("order_id")->label("Order ID")->required()
                            ->exists('new_orders', 'order_id')->hidden(function (Get $get) {
                                if( $get('type') == 'sub' ) {
                                    return false;
                                }
                                return true;
                            }),
                        TextInput::make("client_name")->required(),

                        TextInput::make("client_website")->required(),
                        TextInput::make("no_of_links")->label("No of Links Ordered")->required(),
                        Select::make("order_type")->label("Order Type")
                            ->live()
                            ->options([
                                "gp"    =>  "GP",
                                "niche"    =>  "NICHE"
                            ])->required(),

                        Radio::make("forgotton_category")
                            ->live()
                            ->label("FC")
                            ->options([
                                "1" =>  "Yes",
                                "0" =>  "No"
                            ])->required(),

                        Select::make("order_package")
                            ->required()
                            ->options(function (Get $get){
                                $order_type = $get('order_type');
                                if ($order_type == 'gp') {
                                    return [
                                        "Basic Ahrefs Traffic 500 To 1000" => "Basic Ahrefs Traffic 500 To 1000",
                                        "Silver Ahrefs Traffic 1000 To 3000" => "Silver Ahrefs Traffic 1000 To 3000",
                                        "Gold Ahrefs Traffic 3000 To 5000" => "Gold Ahrefs Traffic 3000 To 5000",
                                        "Platinum Ahrefs Traffic 5000 To 10000" => "Platinum Ahrefs Traffic 5000 To 10000",
                                        "Enterprise Ahrefs Traffic 10000+" => "Enterprise Ahrefs Traffic 10000+",
                                    ];
                                }
                                if ($order_type == 'niche') {
                                    return [
                                        "Basic Ahrefs Ref-Domain Upto 400" => "Basic Ahrefs Ref-Domain Upto 400",
                                        "Standard Ahrefs Ref-Domain 400 to 1000" => "Standard Ahrefs Ref-Domain 400 to 1000",
                                        "Pro Min. Ahrefs Ref-Domain 1000+" => "Pro Min. Ahrefs Ref-Domain 1000+",
                                        "Elite Ahrefs Ref-Domain 3000+" => "Elite Ahrefs Ref-Domain 3000+",
                                    ];
                                }
                            }),

                        Select::make("category")
                            ->searchable()
                            ->options(function (Get $get){
                                $forgotton_category = $get('forgotton_category');
                                if ($forgotton_category == 1) {
                                    return [
                                        "cbd"   =>  "CBD",
                                        "casino"    =>  "Casino",
                                    ];
                                }
                                else{
                                    return  [
                                        "Automobiles" => "Automobiles",
                                        "Animals and pets" => "Animals and pets",
                                        "Adult Relationships and Sex" => "Adult Relationships and Sex",
                                        "Agriculture & Farming" => "Agriculture & Farming",
                                        "Aviation and Flight" => "Aviation and Flight",
                                        "Architecture and Design" => "Architecture and Design",
                                        "Arts" => "Arts",
                                        "Banking and Financial" => "Banking and Financial",
                                        "Beauty and Cosmetics" => "Beauty and Cosmetics",
                                        "Books and Author" => "Books and Author",
                                        "Business and Entrepreneurship" => "Business and Entrepreneurship",
                                        "Career and Employment" => "Career and Employment",
                                        "Construction and Repairs" => "Construction and Repairs",
                                        "CBD Casino Betting and Gambling" => "CBD Casino Betting and Gambling",
                                        "Computers and Electronics" => "Computers and Electronics",
                                        "Cryptocurrency and Bitcoin" => "Cryptocurrency and Bitcoin",
                                        "Culture and Tradition" => "Culture and Tradition",
                                        "Design and Web Development" => "Design and Web Development",
                                        "Digital Marketing SEO and Advertising" => "Digital Marketing SEO and Advertising",
                                        "Environment" => "Environment",
                                        "E-commerce and Shopping" => "E-commerce and Shopping",
                                        "Education" => "Education",
                                        "Entertainment Music Movies and Recreation" => "Entertainment Music Movies and Recreation",
                                        "Fashion and lifestyle" => "Fashion and lifestyle",
                                        "Finance and Investing" => "Finance and Investing",
                                        "Food and Cuisine" => "Food and Cuisine",
                                        "Family and Parenting Child" => "Family and Parenting Child",
                                        "Gadgets" => "Gadgets",
                                        "Games" => "Games",
                                        "General Blog" => "General Blog",
                                        "Gardening" => "Gardening",
                                        "Green Energy & Technology" => "Green Energy & Technology",
                                        "Hardware and Development" => "Hardware and Development",
                                        "Humor" => "Humor",
                                        "Home Improvement and Decor" => "Home Improvement and Decor",
                                        "Health and Fitness" => "Health and Fitness",
                                        "Home Appliances" => "Home Appliances",
                                        "Industry and  Company" => "Industry and  Company",
                                        "Insurance & Investment" => "Insurance & Investment",
                                        "Internet Data & Cyber Law" => "Internet Data & Cyber Law",
                                        "Job Career" => "Job Career",
                                        "Leisure and Hobbies" => "Leisure and Hobbies",
                                        "Literature" => "Literature",
                                        "Love and Dating Relationships" => "Love and Dating Relationships",
                                        "Legal and law" => "Legal and law",
                                        "Manufacturing Machinery and Equipment" => "Manufacturing Machinery and Equipment",
                                        "Marketing" => "Marketing",
                                        "Medical" => "Medical",
                                        "Metallurgy" => "Metallurgy",
                                        "Miscellaneous" => "Miscellaneous",
                                        "Make Money" => "Make Money",
                                        "Movers and Packers" => "Movers and Packers",
                                        "Nature" => "Nature",
                                        "News and Media Updates" => "News and Media Updates",
                                        "Personal Blogs" => "Personal Blogs",
                                        "Places" => "Places",
                                        "Politics" => "Politics",
                                        "Programming" => "Programming",
                                        "Public Service" => "Public Service",
                                        "Product Reviews" => "Product Reviews",
                                        "Photography and Wedding" => "Photography and Wedding",
                                        "Parenting Baby and Moms" => "Parenting Baby and Moms",
                                        "PR Banking" => "PR Banking",
                                        "Real Estate and Homes" => "Real Estate and Homes",
                                        "Religion" => "Religion",
                                        "Science" => "Science",
                                        "Society" => "Society",
                                        "Startups" => "Startups",
                                        "Security" => "Security",
                                        "Society and Enforcements" => "Society and Enforcements",
                                        "Software development Apps Saas and Tools" => "Software development Apps Saas and Tools",
                                        "Sports and Games" => "Sports and Games",
                                        "Social Media" => "Social Media",
                                        "Senior Living" => "Senior Living",
                                        "Technology" => "Technology",
                                        "Telecommunication" => "Telecommunication",
                                        "Travel and Tourism" => "Travel and Tourism",
                                        "Trade and Commerce" => "Trade and Commerce",
                                        "Transportation" => "Transportation",
                                        "Writing and Tools Essay" => "Writing and Tools Essay"
                                    ];
                                }
                            })
                            ->required(),

                        RichEditor::make("message")
                            ->required( )
                            ->columnSpanFull()



                    ])->columns(3)
            ]);
    }


}
