<?php

namespace App\Filament\Manager\Pages;

use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Pages\Page;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Auth;

class PendingOrderFromBloggers extends Page implements HasTable,HasForms
{
    use InteractsWithTable;
    use InteractsWithForms;

    protected static ?int $navigationSort = 90;
    protected static ?string $navigationGroup = "Orders";
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.manager.pages.pending-order-from-bloggers';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrderProcessDetail::whereHas('new_order_process',function ($q){
                    $q->where('manager_id',Auth::id());
                })
                    ->where('status',NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER)
            )
            ->defaultSort('created_at', 'desc')
            ->recordUrl(null)
            ->paginated(config("app.pagination"))
            ->columns([
                TextColumn::make("new_order_process.new_order.order_id")->label("Order Id")->sortable(),
                TextColumn::make("new_order_process.new_order.order_type")->label("Order Type")->badge()->sortable()->color(function (NewOrderProcessDetail $record) {
                    if($record->new_order_process->new_order->order_type == "gp"){
                        return 'info';
                    }else{
                        return 'success';
                    }
                }),
                TextColumn::make("vendor.name")->label("Blogger")->toggleable()->sortable()->description(function (NewOrderProcessDetail $record) {
                    return $record->vendor->email;
                }),
                TextColumn::make("new_site.root_domain")->toggleable()->sortable()->label("Root Domain"),
                TextColumn::make("created_at")->label("Pushed Date"),
            ])
            ->filters([
                // ...
            ])
            ->actions([
                Action::make("cancel_order")

                    ->icon("heroicon-s-x-circle")
                    ->color("danger")
                    ->requiresConfirmation()
                    ->label(" ")->tooltip("Cancel Order")
                    ->form([
                        Textarea::make("rejection_note")
                    ])
                    ->action(function (NewOrderProcessDetail $record,$data){
                        $record->cancel_order_reason = $data['rejection_note'];
                        $record->status = NewOrderStatus::$MANAGER_CANCEL_ORDER_FROM_BLOGGER;
                        $record->save();
                    })
            ])
            ->bulkActions([
                // ...
            ]);
    }

}
