<?php

namespace App\Filament\Clusters\Reporting\Pages;

use App\Filament\Clusters\Reporting;
use App\Filament\Exports\VendorReportingPageExporter;
use App\Models\WalletHistory;
use App\Models\WithdrawRequest;
use Carbon\Carbon;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Pages\Page;
use Filament\Tables\Actions\ExportAction;
use Filament\Tables\Columns\Summarizers\Summarizer;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Enums\FiltersLayout;
use Filament\Tables\Filters\Filter;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Log;
use pxlrbt\FilamentExcel\Actions\Tables\ExportBulkAction;
use pxlrbt\FilamentExcel\Columns\Column;
use pxlrbt\FilamentExcel\Exports\ExcelExport;

class VendorReportingPage extends Page implements HasForms,HasTable
{
    use InteractsWithTable;
    use InteractsWithForms;

    protected static ?string $navigationGroup = "Reports";

    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.clusters.reporting.pages.vendor-reporting-page';

    protected static ?string $cluster = Reporting::class;

    public function table(Table $table): Table
    {
        return $table
            ->query(function (){

                return WithdrawRequest::selectRaw("withdraw_requests.id as id,withdraw_requests.user_id as user_id,wallet_histories.price as amount,
                count(wallet_histories.id) as custom_count,users.email,users.name")
                    ->join("wallet_histories","wallet_histories.withdraw_request_id","withdraw_requests.id")
                    ->join("users","users.id","withdraw_requests.user_id")
                    ->where("withdraw_requests.status",1)
                     ->groupBy(["withdraw_requests.user_id",'wallet_histories.price',"users.email","users.name"]);

            })
//            ->defaultGroup("email")


            ->paginated(config("app.pagination"))

            ->columns([
                TextColumn::make("name")
                    ->formatStateUsing(function ($record){
                        return $record->name;
                    })
                    ->description(function ($record){
                    return $record->email;
                }),
                TextColumn::make("amount")->formatStateUsing(function ($record){
                    return $record->amount;
//                    dd($record);
                }),
                TextColumn::make("custom_count")->formatStateUsing(function ($record){
                    return $record->custom_count;
//                    dd($record);
                }),
                TextColumn::make("id")->label("Total")->formatStateUsing(function ($record){
                    return $record->custom_count * $record->amount;
                })->summarize(
                    Summarizer::make()
                        ->label("Total Amount")
                        ->using(function($query) {
                            $data = $query->get();
                            $total = 0;

                            foreach ($data as $record){
                                $total += $record->custom_count * $record->amount;
                            }

                            return $total;
                        })
                ),
            ])

            ->actions([
                // ...
            ])
            ->filtersLayout(FiltersLayout::AboveContent)
            ->filters([
                Filter::make("search")->form([

                    TextInput::make("name"),
                    DatePicker::make("start_date")->default(function (){
                        return Carbon::today()->subMonth()->format("Y-m-d");
                    })->label("Start Date"),

                    DatePicker::make("end_date")
                        ->default(function (){
                            return Carbon::today()->format("Y-m-d");
                        })
                        ->label("End Date"),

                ])
                    ->query(function (\Illuminate\Database\Eloquent\Builder $query, array $data){
                        return $query
                            ->when($data['name'], function (Builder $query) use ($data){
                                $query->where('name','LIKE','%'.$data['name'].'%')
                                    ->orWhere('email','LIKE','%'.$data['name'].'%')
                                ;
                            })
                            ->when($data['start_date'] && $data['end_date'], function (Builder $query) use ($data){
                                $start_date = Carbon::parse($data['start_date']);
                                $end_date = Carbon::parse($data['end_date']);
                                $query->whereBetween('wallet_histories.approved_date', [$start_date,$end_date ]);
                            });

                    })
                    ->columns(4)->columnSpanFull()
            ])
            ->bulkActions([
//                \Filament\Tables\Actions\ExportBulkAction::make()->exporter(VendorReportingPageExporter::class)
//                ExportBulkAction::make()->exports([
//                    ExcelExport::make("Excel")
//                        ->fromTable()

//                        ->withColumns([
//                            Column::make("name"),
//                            Column::make("email"),
//                            Column::make("amount"),
//                            Column::make("count"),
//                            Column::make("id")->heading("Total")->formatStateUsing(function ($record){
//                                return $record->count * $record->amount;
//                            }),
//                        ])
//                ])
            ]);
    }
}
