<?php

namespace App\Filament\Clusters\Reporting\Pages;

use App\Filament\Clusters\Reporting;
use Carbon\Carbon;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Pages\Page;
use Filament\Tables\Columns\Summarizers\Sum;
use Filament\Tables\Columns\Summarizers\Summarizer;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Enums\FiltersLayout;
use Filament\Tables\Filters\Filter;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class SiteReportingPage extends Page implements HasForms,HasTable
{
    use InteractsWithTable;
    use InteractsWithForms;

    protected static ?string $navigationGroup = "Reports";
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.clusters.reporting.pages.site-reporting-page';

    protected static ?string $cluster = Reporting::class;

    public function table(Table $table): Table
    {
        return $table
            ->query(function (){

                return \App\Models\WalletHistory::selectRaw("wallet_histories.id as id, sum(wallet_histories.price) as amount, new_sites.root_domain")
                    ->join("withdraw_requests","withdraw_requests.id","wallet_histories.withdraw_request_id")
                    ->join("new_order_process_details","new_order_process_details.id","wallet_histories.order_detail_id")
                    ->join("new_sites","new_sites.id","new_order_process_details.new_site_id")
                    ->where("withdraw_requests.status",1)
                    ->groupBy(["new_sites.root_domain"]);

            })

            ->columns([
                TextColumn::make("root_domain")->formatStateUsing(function ($record){
                    return $record->root_domain;
                }),
                TextColumn::make("amount")
                    ->formatStateUsing(function ($record){
                        return $record->amount;
                    })
                    ->label("Amount")->summarize(
                    Sum::make()
                ),
            ])

            ->paginated(config("app.pagination"))
            ->filtersLayout(FiltersLayout::AboveContent)
            ->filters([
                Filter::make("search")->form([
                    TextInput::make("root_domain"),
                    DatePicker::make("start_date")->default(function (){
                        return Carbon::today()->subMonth()->format("Y-m-d");
                    })->label("Start Date"),

                    DatePicker::make("end_date")
                        ->default(function (){
                            return Carbon::today()->format("Y-m-d");
                        })
                        ->label("End Date"),

                ])
                    ->query(function (Builder $query, array $data){
                        return $query
                            ->when($data['root_domain'], function (Builder $query) use ($data){
                                $query->where('root_domain','LIKE','%'.$data['root_domain'].'%');
                            })
                            ->when($data['start_date'] && $data['end_date'], function (Builder $query) use ($data){
                            $query->whereBetween('wallet_histories.approved_date', [$data["start_date"].' 00:00:00', $data["end_date"].' 23:59:59' ]);
                        });

                    })
                    ->columns(4)->columnSpanFull()
            ])
            ->actions([
                // ...
            ])
            ->bulkActions([
                // ...
            ]);
    }
}
