<?php

namespace App\Filament\Blogger\Widgets;

use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Facades\Auth;

class BloggerOrdersWidget extends ChartWidget
{
    protected static bool $isDiscovered = false;
    protected static ?string $heading = 'Chart';

    protected function getData(): array
    {
        $pending_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER])->count();
        $waiting_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS])->count();
        $rejected_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])->count();
        $completed_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED,NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION])->count();

        return [
            'datasets' => [
                [
                    'label' => 'Orders',
                    'data' => [$pending_orders,$waiting_orders,$rejected_orders,$completed_orders],
                    'backgroundColor'=> ['#b91c1c','#a16207','#15803d','#a16207'],
                    'borderWidth' => 0

                ],

            ],
            'labels' => ['Pending Orders','Waiting Orders','Rejected Orders','Completed Orders'],
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
