<?php

namespace App\Filament\Blogger\Resources\TicketResource\Pages;

use App\Filament\Blogger\Resources\TicketResource;
use App\Models\Thread;
use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class CreateTicket extends CreateRecord
{
    protected static string $resource = TicketResource::class;

    protected function handleRecordCreation(array $data): Model
    {
        $thread = new Thread();
        $thread->owner_id = Auth::id();
        $thread->user_id= $data['user'];
        $thread->subject = $data['subject'];
        $thread->save();

        Notification::make()
            ->title("Ticket Created")
            ->success()
            ->send();

//        $manager = User::where('role','manager')->where('id',$data['user'])->first();
//
//        Notification::make()->title("New Thread Created")
//            ->body("Created by ".Auth::user()->name.'('.Auth::user()->email.')')
//            ->success()
//            ->sendToDatabase([$manager]);


        return $thread;
    }
}
