<?php

namespace App\Filament\Blogger\Resources\OrderResource\Pages;

use App\Filament\Blogger\Resources\OrderResource;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Filament\Actions;
use Filament\Resources\Components\Tab;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;

class ListOrders extends ListRecords
{
    protected static string $resource = OrderResource::class;

    protected function getHeaderActions(): array
    {
        return [

        ];
    }

    public function getTabs(): array
    {
        return [
            'all' => Tab::make()->badge(
                NewOrderProcessDetail::where('vendor_id',Auth::id())
                    ->whereIn('status',[
                        NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER,
                        NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS,
                        NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER,
                        NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED,
                        NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION
                    ])
                    ->count()
            ),
            'pending' => Tab::make()
                ->badge(NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER])->count())
                ->modifyQueryUsing(fn (Builder $query) => $query->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER])),
            'waiting' => Tab::make()
                ->badge(NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS])->count())
                ->modifyQueryUsing(fn (Builder $query) => $query->whereIn('status',[NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS])),
            'rejected' => Tab::make()
                ->badge(NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])->count())
                ->modifyQueryUsing(fn (Builder $query) => $query->whereIn('status',[NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])),
            'completed' => Tab::make()
                ->badge(NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED,NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION])->count())
                ->modifyQueryUsing(fn (Builder $query) => $query->whereIn('status',[NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED,NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION])),

        ];
    }

}
