<?php

namespace App\Filament\Blogger\Pages;

use App\Models\BulkUpload;
use App\Models\User;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;
use MongoDB\Driver\Exception\Exception;

class UploadBulkSites extends Page implements HasForms
{
    use InteractsWithForms;
    protected static ?string $navigationGroup = "Bulk Sites";
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.blogger.pages.upload-bulk-sites';

    public ?array $data = [];
    public $bulk_upload_status;

    public function mount(): void
    {
        $this->bulk_upload_status = BulkUpload::where('vendor_id',Auth::user()->id)
            ->where(function ($q){
                $q->where('status',0)->orWhere('status',1);
            })
            ->first();
        $this->form->fill();
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                FileUpload::make("upload_excel")
                    ->label("Upload Excel File")
                    ->previewable(false)
                    ->directory("uploads/excel")
                    ->acceptedFileTypes(["application/vnd.openxmlformats-officedocument.spreadsheetml.sheet","application/vnd.ms-excel","text/csv"])
                    ->required(),
            ])
            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();
        try{

            $bulk_upload= new BulkUpload();
            $bulk_upload->vendor_id= Auth::id();
            $bulk_upload->filename = $data['upload_excel'];
            $bulk_upload->status =0 ;
            $bulk_upload->save();

            Notification::make("success")->title("Successfully Uploaded")->send();

            $admin = User::where('role','admin')->first();

            Notification::make()
                ->title("Upload Bulk Site Request Sent")
                ->body("by ".Auth::user()->name.'('.Auth::user()->email.')')
                ->success()
                ->sendToDatabase([$admin]);

            $this->redirect(UploadBulkSites::getUrl());

        }catch (\Exception $exception){
            dd($exception->getMessage());
        }
    }

}
