<?php

namespace App\Filament\Blogger\Pages;

use App\Models\Country;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Infolists\Components\Actions\Action;
use Filament\Infolists\Components\ImageEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Concerns\InteractsWithInfolists;
use Filament\Infolists\Contracts\HasInfolists;
use Filament\Infolists\Infolist;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Support\Enums\FontWeight;
use Illuminate\Support\Facades\Auth;

class Profile extends Page implements HasForms , HasInfolists
{
    use InteractsWithForms;
    use InteractsWithInfolists;

    public ?array $data = [];

    public $user = null;
    protected static bool $shouldRegisterNavigation = false;

    public function mount(): void
    {
        $this->user  = \auth()->user();
        $this->form->fill();
    }
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.blogger.pages.profile';



    public function userInfoList(Infolist $infolist): Infolist
    {
        return $infolist
            ->record($this->user)
            ->schema([
                \Filament\Infolists\Components\Section::make("My Profile")
                    ->headerActions([
                        Action::make("update_profile")
                            ->modalHeading(" ")
                            ->form([
                                Section::make("Update Profile")->description("Update your profile information")->schema([

                                    TextInput::make('name')
                                        ->default(function (){
                                            return Auth::user()->name;
                                        })
                                        ->inlineLabel()->required(),

                                    Select::make("country_id")
                                        ->required()
                                        ->default(Auth::user()->country_id)
                                        ->options(Country::orderBy('name','asc')->pluck("name","id"))
                                        ->inlineLabel(),
                                    TextInput::make('whatsapp')->default(Auth::user()->whatsapp)->inlineLabel()->required(),
                                    TextInput::make('skype')->default(Auth::user()->skype)->inlineLabel()->required(),
                                    Section::make("For Indian Users")->schema([
                                        TextInput::make('aadhar_number')->default(Auth::user()->aadhar_number)->inlineLabel(),
                                        TextInput::make('pancard_number')->default(Auth::user()->pancard_number)->inlineLabel(),
                                        TextInput::make('gst_number')->default(Auth::user()->gst_number)->inlineLabel(),
                                    ])->hidden(function (){
                                        if( Auth::user()->country_id == 1 ){
                                            return false;
                                        }
                                        return true;
                                    }),
                                    FileUpload::make("profile_image")
                                        ->default(Auth::user()->profile_image)
                                        ->label("Profile Image")
                                        ->directory("uploads")
                                        ->image(),

                                ])->columnSpan(1),
                            ])
                            ->action(function ($record,$data){
                                try{
                                    if( Auth::user()->country_id == 1 ){
                                        Auth::user()->update([
                                            "name"  => $data['name'],
                                            "country_id"    => $data['country_id'],
                                            "whatsapp"  => $data['whatsapp'],
                                            "aadhar_number"  => $data['aadhar_number'],
                                            "pancard_number"  => $data['pancard_number'],
                                            "gst_number"  => $data['gst_number'],
                                            "skype"  => $data['skype'],
                                            "profile_image" => $data['profile_image']
                                        ]);
                                    }else{
                                        Auth::user()->update([
                                            "name"  => $data['name'],
                                            "country_id"    => $data['country_id'],
                                            "whatsapp"  => $data['whatsapp'],

                                            "skype"  => $data['skype'],
                                            "profile_image" => $data['profile_image']
                                        ]);
                                    }


                                    Notification::make("success")->title("Profile Updated")->success()->send();
                                    $this->redirect(Profile::getUrl());
                                }catch (\Exception $exception){
                                    dd($exception->getMessage());
                                }

                            })
                    ])
                    ->schema([
                        ImageEntry::make("profile_image")->label("")->height(100)->width(100)->inlineLabel()->columnSpanFull(),
                        TextEntry::make("name")->label(" ")
                            ->size(TextEntry\TextEntrySize::Large)
                            ->weight(FontWeight::Bold)->columnSpanFull(),
                    TextEntry::make("id")->label("Wallet Balance")
                        ->badge()
                        ->formatStateUsing(function ($record){
                            return vendor_balance();
                        })
                        ->size(TextEntry\TextEntrySize::Large)
                        ->weight(FontWeight::Bold),




                    TextEntry::make("email")->label("Email Address")->color("primary")->inlineLabel(),
                    TextEntry::make("created_at")->label("Joined On")->color("primary")->inlineLabel()->columnSpanFull(),
                    TextEntry::make("country.name")->label("Country")->color("primary")->inlineLabel()->columnSpanFull(),
                    TextEntry::make("whatsapp")->label("Whatsapp")->color("primary")->inlineLabel()->columnSpanFull(),
                    TextEntry::make("skype")->label("Skype")->color("primary")->inlineLabel()->columnSpanFull(),

                    \Filament\Infolists\Components\Section::make("for_indian_users")->heading("For Indian Users")->schema([
                        TextEntry::make("aadhar_number")->label("Aadhar Number")->color("primary")->inlineLabel()->columnSpanFull(),
                        TextEntry::make("pancard_number")->label("Pancard Number")->color("primary")->inlineLabel()->columnSpanFull(),
                        TextEntry::make("gst_number")->label("GST Number")->color("primary")->inlineLabel()->columnSpanFull(),
                    ])->hidden(function (){
                        if( Auth::user()->country_id == 1 ){
                            return false;
                        }
                        return true;
                    }),

                    TextEntry::make("updated_at")->label("Access Role")
                        ->formatStateUsing(function ($record){
                            return 'Blogger';
                        })
                        ->color("primary")->inlineLabel()->columnSpanFull(),

                ])->columns(2),



            ]);
    }


}
