<?php

namespace App\Filament\Blogger\Pages;

use App\Models\WithdrawRequest;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Pages\Page;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\Summarizers\Sum;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;

class InvoiceList extends Page implements HasForms, HasTable
{
    use InteractsWithTable;
    use InteractsWithForms;

    protected static ?string $navigationGroup = "Payments";
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.blogger.pages.invoice-list';


    public function table(Table $table): Table
    {
        return $table
            ->query(
                WithdrawRequest::has("wallet_histories")->with("request_date")->withSum(['wallet_histories as total_price' => function ($query) {
                    $query->select(DB::raw('SUM(price)'));
                }], 'price')->where('status',1)->where('user_id',Auth::id())
            )
            ->defaultSort('id','desc')
            ->columns([
                TextColumn::make("id"),
                TextColumn::make("invoice_number")->formatStateUsing(function (WithdrawRequest $record) {
                    return $record->invoice_pre.$record->invoice_number;
                }),
                TextColumn::make("created_at")->label("Payment Method")
                    ->wrap()
                    ->description(function (WithdrawRequest $record) {
                        if( $record->wallet_histories[0]->payment_method  == 'bank' ){
                            return new HtmlString('
                                <strong>Bank Type:- </strong>'.$record->wallet_histories[0]->bank_type.' <br>
                                <strong>Beneficiary Account Number:- </strong>'.$record->wallet_histories[0]->beneficiary_account_number.' <br>
                                <strong>Beneficiary Name:- </strong>'.$record->wallet_histories[0]->beneficiary_name.' <br>
                                <strong>Customer Reference Number:- </strong>'.$record->wallet_histories[0]->customer_reference_number.' <br>
                                <strong>Beneficiary Bank Name:- </strong>'.$record->wallet_histories[0]->bene_bank_name.' <br>
                                <strong>Beneficiary Bank Branch Name:- </strong>'.$record->wallet_histories[0]->bene_bank_branch_name.' <br>
                                <strong>IFSC Code:- </strong>'.$record->wallet_histories[0]->ifsc_code.' <br>
                                <strong>Beneficiary Email id:- </strong>'.$record->wallet_histories[0]->beneficiary_email_id .' <br>'

                            );
                        }


                        if($record->wallet_histories[0]->payment_method == "qr_code") {
                            return new HtmlString('<div class="flex items-center flex-col justify-between border-b border-gray-200 mt-2 pb-1 mb-1" >

                                    <span class="text-black font-bold" >
                                    <a href = "/uploads/'.$record->wallet_histories[0]->qr_code_image .'" target = "_blank" >
                                        <img src = "/uploads/'.$record->wallet_histories[0]->qr_code_image .'" class="w-32" >
                                    </a >
                                    </span >
                                </div >');
                        }

                        if($record->wallet_histories[0]->payment_method == "paypal_id") {
                            return $record->wallet_histories[0]->paypal_email;

                        }

                        if($record->wallet_histories[0]->payment_method == "upi_id") {
                            return $record->wallet_histories[0]->upi_id;

                        }

                    })
                    ->badge()
                    ->color(function (WithdrawRequest $record) {
                        if( $record->wallet_histories[0]->payment_method  == 'bank' ){
                            return 'success';
                        }


                        if($record->wallet_histories[0]->payment_method == "qr_code") {
                            return 'danger';
                        }

                        if($record->wallet_histories[0]->payment_method == "paypal_id") {
                            return 'info';

                        }

                        if($record->wallet_histories[0]->payment_method == "upi_id") {
                            return 'warning';

                        }

                    })
                    ->formatStateUsing(function (WithdrawRequest $record) {

                        if( $record->wallet_histories[0]->payment_method  == 'bank' ){
                            return 'Bank Details';
                        }


                        if($record->wallet_histories[0]->payment_method == "qr_code") {
                            return 'QR Code';
                        }

                        if($record->wallet_histories[0]->payment_method == "paypal_id") {
                            return 'Paypal ID';

                        }

                        if($record->wallet_histories[0]->payment_method == "upi_id") {
                            return 'UPI ID';

                        }



                    }),
                TextColumn::make("total_price")->label("Amount")->summarize(Sum::make())->sortable(),
                TextColumn::make("request_date.approved_date")->label("Datetime")->dateTime(),

            ])
            ->filters([
                // ...
            ])
            ->actions([
                Action::make("invoice")->label(" ")
                    ->url(function (WithdrawRequest $record) {
                        return $record->invoice_file;
                    })->hidden(function (WithdrawRequest $record) {
                        if(!$record->invoice_file){
                            return true;
                        }

                        return false;
                    })
                    ->tooltip("Invoice")->icon("heroicon-o-book-open")
            ])
            ->bulkActions([
                // ...
            ]);
    }

}
