<?php

namespace App\Filament\Blogger\Pages;


use App\Harman\Helpers\FileProcess;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;

class FillPaymentDetails extends Page implements HasForms
{
    protected static ?string $navigationGroup = "Payments";
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.blogger.pages.fill-payment-details';

    use InteractsWithForms;

    public ?array $data = [];

    public function mount(): void
    {
        if(!Auth::user()->country){
            Notification::make("error")->title("Please Complete your profile")->send();
            $this->redirect(Profile::getUrl());
        }
        $this->form->fill([
            'bank_type' => Auth::user()->bank_type,
            'beneficiary_name' => Auth::user()->beneficiary_name,
            'beneficiary_account_number' => Auth::user()->beneficiary_account_number,
            'customer_reference_number' => Auth::user()->customer_reference_number,
            'ifsc_code' => Auth::user()->ifsc_code,
            'bene_bank_name' => Auth::user()->bene_bank_name,
            'bene_bank_branch_name' => Auth::user()->bene_bank_branch_name,
            'beneficiary_email_id' => Auth::user()->beneficiary_email_id,
            'upi_id' => Auth::user()->upi_id,
            'qr_code_image' => Auth::user()->qr_code_image ,
            'paypal_id' => Auth::user()->paypal_email,
        ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Bank Details")->schema([
                    TextInput::make("bank_type")->label("Account Type"),
                    TextInput::make("beneficiary_account_number")->label("Beneficiary Account Number"),
                    TextInput::make("beneficiary_name")->label("Beneficiary Name"),
                    TextInput::make("bene_bank_name")->label("Bank Name"),

                    TextInput::make("ifsc_code")->label("IFSC Code"),

                    TextInput::make("bene_bank_branch_name")->label("Bank Branch Name"),
                    TextInput::make("beneficiary_email_id")->label("Beneficiary Email id"),
                    TextInput::make("customer_reference_number")->label("Customer Reference Number"),
                ])
                    ->hidden(function (){
                        if(in_array("bank",json_decode(Auth::user()->country->payment_methods))){
                            return false;
                        }
                        return true;
                    })
                    ->columns(4),



                Section::make("UPI Details")->schema([
                    TextInput::make("upi_id")->label("UPI Id"),
                ]) ->hidden(function (){
                    if(in_array("upi_id",json_decode(Auth::user()->country->payment_methods))){
                        return false;
                    }
                    return true;
                }),

                Section::make("Paypal Details")->schema([
                    TextInput::make("paypal_id")->label("Paypal ID"),
                ]) ->hidden(function (){
                    if(in_array("paypal",json_decode(Auth::user()->country->payment_methods))){
                        return false;
                    }
                    return true;
                }),

                Section::make("QR Code")->schema([
                    FileUpload::make("qr_code_image")
                        ->image()
                        ->label("Upload QR Code Image"),
                ]) ->hidden(function (){
                    if(in_array("qr_code",json_decode(Auth::user()->country->payment_methods))){
                        return false;
                    }
                    return true;
                }),

            ])
            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();


        try{
            $u= Auth::user();
            $u->bank_type = $data['bank_type'] ?? "";
            $u->beneficiary_name = $data['beneficiary_name'] ?? "";
            $u->beneficiary_account_number = $data['beneficiary_account_number'] ?? "";
            $u->customer_reference_number = $data['customer_reference_number'] ?? "";
            $u->ifsc_code = $data['ifsc_code'] ?? "";
            $u->bene_bank_name = $data['bene_bank_name'] ?? "";
            $u->bene_bank_branch_name = $data['bene_bank_branch_name'] ?? "";
            $u->beneficiary_email_id = $data['beneficiary_email_id'] ?? "";

            if(isset($data['upi_id'])) {
                $u->upi_id = $data['upi_id'];
            }

            if(isset($data['qr_code_image'])) {
                $u->qr_code_image = $data['qr_code_image'];
            }

            if(isset($data['paypal_id'])) {
                $u->paypal_email = $data['paypal_id'];
            }
            $u->save();

            Notification::make("success")->title("Payment Details Updated")->send();

        }catch (\Exception $exception){
           dd($exception->getMessage());
        }
    }
}
