<?php

namespace App\Providers\Filament;

use App\Filament\Auth\WriterLogin;
use App\Filament\Writer\Pages\ChangePassword;
use App\Filament\Writer\Pages\Profile;
use App\Filament\Writer\Widgets\OrderAddedTodayNotificationWidget;
use App\Filament\Writer\Widgets\RejectedTodayNotificationWidget;
use App\Filament\Writer\Widgets\WriterStatsWidget;
use App\Http\Middleware\WriterMiddleware;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\MenuItem;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\MaxWidth;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;

class WriterPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('writer')
            ->brandName("Writer Panel")
            ->path('writer')
            ->colors([
                'primary' => Color::Amber,
            ])
//            ->login(WriterLogin::class)
                ->login()
            ->brandLogo(asset("images/logo1.jpeg"))
            ->sidebarCollapsibleOnDesktop()
            ->topNavigation(true)
            ->maxContentWidth(MaxWidth::Full)
            ->discoverResources(in: app_path('Filament/Writer/Resources'), for: 'App\\Filament\\Writer\\Resources')
            ->discoverPages(in: app_path('Filament/Writer/Pages'), for: 'App\\Filament\\Writer\\Pages')
            ->pages([
                Pages\Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Writer/Widgets'), for: 'App\\Filament\\Writer\\Widgets')
            ->widgets([
              WriterStatsWidget::class,
                OrderAddedTodayNotificationWidget::class,
                RejectedTodayNotificationWidget::class
            ])
            ->userMenuItems([
                MenuItem::make()->label("Profile")
                    ->icon('heroicon-o-user')
                    ->url(function (){
                        return Profile::getUrl();
                    }),
                MenuItem::make()->label("Change Password")
                    ->icon('heroicon-o-cog-6-tooth')
                    ->url(function (){
                        return ChangePassword::getUrl();
                    }),
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
                WriterMiddleware::class
            ]) ->databaseNotifications()
            ->databaseNotificationsPolling('30s');
    }
}
