<?php

namespace App\Providers\Filament;

use App\Filament\Auth\TeamLogin;
use App\Filament\Team\Pages\ChangePassword;
use App\Filament\Team\Pages\Profile;
use App\Filament\Team\Widgets\TeamStatsWidget;
use App\Filament\Team\Widgets\TodayOrderAddedNotificationWidget;
use App\Filament\Team\Widgets\TodayRejectedLinksNotificationWidget;
use App\Http\Middleware\TeamMiddleware;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\MenuItem;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\MaxWidth;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;

class TeamPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('team')
            ->path('team')

            ->brandName("Team Panel")
            ->brandLogo(asset("images/logo1.jpeg"))
            ->colors([
                'primary' => Color::Amber,
            ])
            ->login()
//            ->login(TeamLogin::class)
            ->topNavigation(true)
            ->maxContentWidth(MaxWidth::Full)
            ->sidebarCollapsibleOnDesktop()
            ->discoverResources(in: app_path('Filament/Team/Resources'), for: 'App\\Filament\\Team\\Resources')
            ->discoverPages(in: app_path('Filament/Team/Pages'), for: 'App\\Filament\\Team\\Pages')
            ->pages([
                Pages\Dashboard::class,
            ])
            ->userMenuItems([
                MenuItem::make()->label("Profile")
                    ->icon('heroicon-o-user')
                    ->url(function (){
                        return Profile::getUrl();
                    }),
                MenuItem::make()->label("Change Password")
                    ->icon('heroicon-o-cog-6-tooth')
                    ->url(function (){
                        return ChangePassword::getUrl();
                    }),
            ])
            ->discoverWidgets(in: app_path('Filament/Team/Widgets'), for: 'App\\Filament\\Team\\Widgets')
            ->widgets([
                TeamStatsWidget::class,
                TodayOrderAddedNotificationWidget::class,
                TodayRejectedLinksNotificationWidget::class
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
                TeamMiddleware::class
            ]) ->databaseNotifications()
            ->databaseNotificationsPolling('30s');
    }
}
