<?php

namespace App\Providers\Filament;

use App\Filament\Auth\ManagerLogin;
use App\Filament\Manager\Pages\ChangePassword;
use App\Filament\Manager\Pages\Profile;
use App\Filament\Manager\Resources\NewOrderResource;
use App\Filament\Manager\Widgets\ManagerStatsWidget;
use App\Filament\Manager\Widgets\TodayPendingApprovalsForBloggersWidget;
use App\Filament\Manager\Widgets\TodayPendingApprovalsForTeamsWidget;
use App\Filament\Manager\Widgets\TodayPendingApprovalsForWritersWidget;
use App\Filament\Manager\Widgets\TodayRejectedOrdersForBloggersWidget;
use App\Http\Middleware\ManagerMiddleware;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\MenuItem;
use Filament\Navigation\NavigationItem;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\MaxWidth;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;

class ManagerPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->brandName("Manager Panel")
            ->brandLogo(asset("images/logo1.jpeg"))
            ->id('manager')
            ->path('manager')
            ->login()
//            ->login(ManagerLogin::class)

            ->sidebarCollapsibleOnDesktop()
            ->topNavigation(true)
            ->maxContentWidth(MaxWidth::Full)
            ->colors([
                'primary' => Color::Fuchsia,
            ])
            ->discoverResources(in: app_path('Filament/Manager/Resources'), for: 'App\\Filament\\Manager\\Resources')
            ->discoverPages(in: app_path('Filament/Manager/Pages'), for: 'App\\Filament\\Manager\\Pages')
            ->pages([
                Pages\Dashboard::class,
            ])
            ->navigationItems([
                NavigationItem::make('New Order')
                    ->url(function (){
                        return NewOrderResource::getUrl('create');
                    })
                    ->group("Orders")
                    ->icon('heroicon-o-presentation-chart-line')
                    ->isActiveWhen(function (){
                        return request()->routeIs('filament.manager.resources.new-orders.create');
                    })
            ])
            ->discoverWidgets(in: app_path('Filament/Manager/Widgets'), for: 'App\\Filament\\Manager\\Widgets')
            ->widgets([
                ManagerStatsWidget::class,
                TodayPendingApprovalsForBloggersWidget::class,
                TodayPendingApprovalsForTeamsWidget::class,
                TodayPendingApprovalsForWritersWidget::class,
                TodayRejectedOrdersForBloggersWidget::class
            ])
            ->userMenuItems([
                MenuItem::make()->label("Profile")
                    ->icon('heroicon-o-user')
                    ->url(function (){
                        return Profile::getUrl();
                    }),
                MenuItem::make()->label("Change Password")
                    ->icon('heroicon-o-cog-6-tooth')
                    ->url(function (){
                        return ChangePassword::getUrl();
                    }),
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->darkMode(false)
            ->databaseNotifications()
            ->databaseNotificationsPolling('60s')
            ->authMiddleware([
                Authenticate::class,
                ManagerMiddleware::class
            ]);
    }
}
