<?php

namespace App\Providers\Filament;

use App\Filament\Auth\AdminLogin;
use App\Filament\Pages\ChangePassword;
use App\Filament\Widgets\BloggersJoinedChart;
use App\Filament\Widgets\MembersOverview;
use App\Filament\Widgets\MonthlyOrdersChart;
use App\Filament\Widgets\OrdersViewChart;
use App\Filament\Widgets\PendingBulkUploadRequestsWidget;
use App\Filament\Widgets\PendingWithdrawalRequestsWidgets;
use App\Filament\Widgets\TeamLoginChart;
use App\Filament\Widgets\WriterLoginChart;
use App\Filament\Widgets\YearlyPaymentChart;
use App\Http\Middleware\AdminMiddleware;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\MenuItem;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\MaxWidth;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use pxlrbt\FilamentSpotlight\SpotlightPlugin;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->default()
            ->brandName("Link Management")
            ->id('admin')
            ->path('admin')
            ->brandLogo(asset("images/logo1.jpeg"))
            ->topNavigation(true)
            ->maxContentWidth(MaxWidth::Full)
//            ->login(AdminLogin::class)
            ->login()
            ->sidebarCollapsibleOnDesktop()
            ->colors([
                'primary' => Color::Amber,
            ])
            ->plugins([
                SpotlightPlugin::make()
            ])
            ->userMenuItems([
                MenuItem::make()->label("Change Password")
                    ->icon('heroicon-o-cog-6-tooth')
                    ->url(function (){
                        return ChangePassword::getUrl();
                    })
            ])
            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            ->pages([
                Pages\Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->discoverClusters(in: app_path('Filament/Clusters'), for: 'App\\Filament\\Clusters')
            ->widgets([
                MembersOverview::class,
                PendingWithdrawalRequestsWidgets::class,
                OrdersViewChart::class,
                MonthlyOrdersChart::class,
                YearlyPaymentChart::class,
               BloggersJoinedChart::class,

               PendingBulkUploadRequestsWidget::class,
               TeamLoginChart::class,
                WriterLoginChart::class,

            ])
            ->darkMode(false)
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])

            ->databaseNotifications()
            ->databaseNotificationsPolling('60s')
            ->authMiddleware([
                Authenticate::class,
                AdminMiddleware::class
            ]);
    }
}
