<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Wallet extends Model
{
    use HasFactory;

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function wallet_histories()
    {
        return $this->hasMany(WalletHistory::class);
    }

    public function wallet_balance()
    {
        return $this->hasMany(WalletHistory::class)->where('approved_date','=',null);
    }
}
