<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Thread extends Model
{
    use HasFactory;

    public function last_updated()
    {
        return $this->hasOne(Message::class,"thread_id")->orderBy("id","desc");
    }

    public function owner()
    {
        return $this->belongsTo(User::class,"owner_id")->select("id","name","role");
    }

    public function user()
    {
        return $this->belongsTo(User::class,"user_id")->select("id","name","role");
    }

    public function messages()
    {
        return $this->hasMany(Message::class);
    }
}
