<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Site extends Model
{
    use HasFactory;

    public function site_multiple_category_type()
    {
        return $this->hasMany(SiteMultiple::class)->where('master_type_url_slug','category-type');
    }

    public function site_multiple_traffic_source()
    {
        return $this->hasMany(SiteMultiple::class)->where('master_type_url_slug','traffic-source');
    }

    public function site_multiple_grey_niche()
    {
        return $this->hasMany(SiteMultiple::class)->where('master_type_url_slug','grey-niche');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function order_detail()
    {
        return $this->hasMany(OrderDetail::class);
    }

}
