<?php

namespace App\Models;

use App\Project\NewOrderStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrdersView extends Model
{
    use HasFactory;
    protected $table = "orders_view";

    public function new_order_processes()
    {
        return $this->hasOne(NewOrderProcess::class,"new_order_id","id")->where('status',NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER);
    }


    public function new_order_processes_many()
    {
        return $this->hasManyThrough(
            NewOrderProcessDetail::class,
            NewOrderProcess::class,
            "new_order_id",
            "new_order_process_id",
            "id",
            "id"
        )->where('new_order_processes.status',NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER);
//        return $this->hasMany(NewOrderProcess::class,"new_order_id","id")->where('status',NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER);
    }
}
