<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NewSite extends Model
{
    use HasFactory;
    public $fillable= [
      "uploaded_user_id", "root_domain","dr","rd","da","traffic_source",
        "da","category","spam_score","gp_price","niche_edit_price","deal_cbd_casino",
        "email","site_status","source","website_niche","paypal_id","skype","whatsapp","country_source","sample_url","website_status","href_url",
        "total_time","fc_gp","fc_ne","bulk_upload_id","bulk_upload_status","delete_site"
    ];

    public function uploaded_user()
    {
        return $this->belongsTo(User::class,"uploaded_user_id");
    }

    public function dupl()
    {
        return $this->belongsTo(NewSite::class,"root_domain","root_domain");
    }


    public function new_order_process_detail()
    {
        return $this->hasOne(NewOrderProcessDetail::class)->orderBy('id','desc');
    }

}
