<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NewOrderProcess extends Model
{
    use HasFactory;

    public function new_order_process_details_count()
    {
        return $this->hasMany(NewOrderProcessDetail::class,"new_order_process_id","id")
                ->whereIn('status',[7,8]);
    }

    public function new_order_process_details()
    {
        return $this->hasMany(NewOrderProcessDetail::class,"new_order_process_id","id");
    }

    public function new_order()
    {
        return $this->belongsTo(NewOrder::class);
    }

    public function writer()
    {
        return $this->belongsTo(User::class)->where('role','writer');
    }

    public function team()
    {
        return $this->belongsTo(User::class,"team_id","id");
    }
}
