<?php

namespace App\Models;

use App\Project\NewOrderStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NewOrder extends Model
{
    use HasFactory;


    public function team()
    {
        return $this->belongsTo(User::class)->where('role','team');
    }

    public function new_order_processes_count()
    {
        return $this->hasOne(NewOrderProcess::class,"new_order_id")->where('status',5);
    }

    public function new_order_processes()
    {
        return $this->hasMany(NewOrderProcess::class)->orderBy("created_at");
    }

    public function only_manager_pushed_to_blogger()
    {
        return $this->hasMany(NewOrderProcess::class,"new_order_id")->where('status',NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER);
    }

    public function manager()
    {
        return $this->belongsTo(User::class)->where('role','manager');
    }

    public function order_processes_team_pushed_to_manager()
    {
        return $this->hasOne(NewOrderProcess::class,"new_order_id")->where('status',1)->orderBy('id','desc');
    }

    public function order_processes_manager_rejected_and_pushed_to_team()
    {
        return $this->hasOne(NewOrderProcess::class,"new_order_id")->where('status',NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM)->orderBy('id','desc');
    }

    public function order_processes_manager_pushed_to_writer()
    {
        return $this->hasOne(NewOrderProcess::class,"new_order_id")
                ->where('status',NewOrderStatus::$MANAGER_PUSHED_TO_WRITER)->orderBy('id','desc');
    }

    public function order_processes_manager_rejected_and_pushed_to_writer(){
        return $this->hasOne(NewOrderProcess::class,"new_order_id")
            ->where('status',NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER)->orderBy('id','desc');
    }

    public function order_processes_writer_pushed_to_manager()
    {
        return $this->hasOne(NewOrderProcess::class,"new_order_id")
            ->where('status',NewOrderStatus::$WRITER_PUSHED_TO_MANAGER)->orderBy('id','desc');
    }



}
