<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BulkUploadSite extends Model
{
    use HasFactory;
    public $fillable= [
        "bulk_upload_id", "root_domain","dr","rd","da","traffic",
        "da","category","spam_score","gp_price","niche_edit_price","deal_cbd_casino",
        "email","site_status","source","uploaded_user_id"
    ];

    public function bulk_upload()
    {
        return $this->belongsTo(BulkUpload::class);
    }

    public function dupl()
    {
        return $this->belongsTo(BulkUploadSite::class,"root_domain","root_domain");
    }

}
