<?php

namespace App\Livewire\Vendor;

use App\Models\NewSite;
use App\Models\Site;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Livewire\Component;
use Illuminate\Http\Request;

class AddNewSiteLivewire extends Component
{

    public $step = 1;

    public $association_type = null;
    public $domain_type = null;
    public $root_domain = null;
    public $niche = null;
    public $category = null;
    public $traffic_source = null;
    public $spam_score = null;
    public $word_count = null;
    public $sample_url = null;


    public $marked_sponsor = null;
    public $link_type = null;
    public $link_validity = null;
    public $accept_grey_niche = null;
    public $grey_niche_types = [];

    public $total_time = "";

    public $da = null;
    public $dr = null;
    public $traffic = null;
    public $gp_price = null;
    public $rd = null;
    public $niche_edit_price = null;
    public $fc_gp = null;
    public $fc_ne = null;


    public function render()
    {
        return view('livewire.vendor.add-new-site-livewire');
    }

    public function updatedGpPrice()
    {
        if( empty($this->traffic) ){
            $this->addError('traffic',"The traffic field is required");
        }else{
            $q= DB::table("price_charts")
                ->whereRaw("traffic_start_range <= ".$this->traffic." and traffic_end_range > ".$this->traffic." " )
                ->first();


                if( $this->gp_price > $q->gp_end_range ){
                    $this->addError('gp_price',"Please lower your price. It does not meet our pricing criteria");
                }else{
                    $this->resetValidation('gp_price');
                }

        }
    }

    public function updatedNicheEditPrice()
    {
        if( empty($this->rd) ){
            $this->addError('rd',"The rd field is required");
        }else{
            $query= DB::table("price_charts")
                ->whereRaw("rd_start_range <= ".$this->rd." and rd_end_range > ".$this->rd." " )
                ->first();

                if( $this->niche_edit_price > $query->niche_end_range ){
                    $this->addError('niche_edit_price','Please lower your price. It does not meet our pricing criteria') ;
                }else{
                    $this->resetValidation('niche_edit_price');
                }

        }
    }


    public function rules()
    {
            return [
//                "association_type"          =>          "required",
//                "domain_type"               =>          "required",
                "root_domain"               =>          "required",
//                "niche"                     =>          "required",
                "category"                  =>          "required",
                "traffic_source"            =>          "required",
                "spam_score"                =>          "required",
                "sample_url"                =>          "nullable|url",
                "marked_sponsor"            =>          "required",
//                "link_type"                 =>          "required",
//                "link_validity"             =>          "required",
                "accept_grey_niche"         =>          "required",
                "da"                        =>          "required|numeric",
                "dr"                        =>          "required|numeric",
                "traffic"                   =>          "required|numeric",
                "gp_price"                  =>          "required|numeric",
                "rd"                        =>          "required|numeric",
                "niche_edit_price"          =>          "required|numeric",
                "total_time"          =>          "required|numeric",
            ];
    }


    public function step3()
    {
        $this->validate();

         try {
            $new_site= new NewSite();
            $new_site->uploaded_user_id= Auth::id();
            $new_site->association_type= $this->association_type;
            $new_site->domain_type= $this->domain_type;
            $new_site->root_domain= $this->root_domain;
            $new_site->niche= $this->niche;
            $new_site->category= $this->category;
            $new_site->country_source= $this->traffic_source;
            $new_site->spam_score= $this->spam_score;
            $new_site->sample_url= $this->sample_url;
            $new_site->total_time= $this->total_time;

            $new_site->marked_sponsor= $this->marked_sponsor;
            $new_site->link_type= $this->link_type;
            $new_site->link_validity= $this->link_validity;
            $new_site->accept_grey_niche= $this->accept_grey_niche;
            $new_site->grey_niche_types= implode(",",$this->grey_niche_types);

            $new_site->da= $this->da;
            $new_site->dr= $this->dr;
            $new_site->traffic_source= $this->traffic;
            $new_site->gp_price= $this->gp_price;
            $new_site->niche_edit_price= $this->niche_edit_price;
            $new_site->rd= $this->rd;
            $new_site->fc_gp= $this->fc_gp;
            $new_site->fc_ne= $this->fc_ne;

            $new_site->site_status = 0 ;
            $new_site->source = "Website";

            $new_site->save();

            return redirect()->route("new-site.create")->with("success","Site Added");
         }catch (\Exception $exception){
             return redirect()->back()->with("error",$exception->getMessage());
         }

    }


}
