<?php

namespace App\Livewire\Manager\Messages;

use App\Models\Thread;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\WithPagination;

class ViewThreadsLivewire extends Component
{
    use WithPagination;

    public function render()
    {
        $query= Thread::query();

        $query->where('owner_id', Auth::id())->orWhere('user_id',Auth::id());

        $threads = $query->with("last_updated")->withCount("messages")->orderBy('updated_at','desc')->simplePaginate(100);

        return view('livewire.manager.messages.view-threads-livewire',compact("threads"));
    }
}
