<?php

namespace App\Livewire\Manager\Messages;

use App\Models\Thread;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class CreateNewThreadLivewire extends Component
{
    public $role = "";
    public $user= "";
    public $users= [];
    public $subject = "";

    public function updatedRole()
    {
        switch ($this->role){
            case "vendor":
                $this->users = User::where('role','vendor')->get();
                break;

            case "team":
                $this->users = User::where('role','team')->get();
                break;

            case "writer":
                $this->users = User::where('role','writer')->get();
                break;

            case "manager":
                $this->users= User::where('role','manager')->get();
                break;

        }
    }

    public function render()
    {
        return view('livewire.manager.messages.create-new-thread-livewire');
    }

    public function createThread()
    {


            $this->validate([
                "role"       =>      "required",
                "user"       =>      "required",
                "subject"       =>      "required",
            ]);

            try{

                $thread = new Thread();
                $thread->owner_id = Auth::id();
                $thread->user_id= $this->user;
                $thread->subject = $this->subject;
                $thread->save();

                switch (Auth::user()->role){
                    case "vendor":
                        $this->redirect(route("vendor.messages.detail",$thread->id));
                        break;

                    case "team":
                        $this->redirect(route("team.messages.threads",$thread->id));
                        break;

                    case "writer":
                        $this->redirect(route("writer.messages.detail",$thread->id));
                        break;

                    case "manager":
                        $this->redirect(route("manager.messages.detail",$thread->id));
                        break;

                }
                session()->flash("success","Thread Created");





            }catch (\Exception $exception){
                session()->flash("error",$exception->getMessage());
            }




    }
}
