<?php

namespace App\Livewire\Admin;

use App\Mail\NewSiteAccept;
use App\Models\NewSite;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Livewire\Component;
use Livewire\WithPagination;
use PHPUnit\Exception;

class ViewAllSitesLivewire extends Component
{
    use WithPagination;
    public $root_domain = "";
    public $fc = '';
    public $new_arrival = '';
    public $site_status = "";
    public $category = "";
    public $website_niche = "";
    public $dr_start_range = "";
    public $dr_end_range = "";
    public $da_start_range = "";
    public $da_end_range = "";
    public $rd_start_range = "";
    public $rd_end_range = "";
    public $traffic_start_range = "";
    public $traffic_end_range = "";
    public $gpprice_start_range = "";
    public $gpprice_end_range = "";
    public $nicheprice_start_range = "";
    public $nicheprice_end_range = "";
    public $traffic = "";
    public $gp_price = "";
    public $niche_price = "";
    public $column_name = "root_domain";

    public $dr_options = [
        'start' => [
            0,
            100
        ],
        'step' => 1,
        'range' => [
            'min' =>  [0],
            'max' => [100]
        ],
        'connect' => true,
        'behaviour' => 'tap-drag',
        'tooltips' => true,

    ];

    public $dr_range = [
        'min' => 0, // Targets handle 1 value
        'max' => 100 // Targets handle 2 value
    ];

    public $da_options = [
        'start' => [
            0,
            100
        ],
        'range' => [
            'min' =>  [1],
            'max' => [100]
        ],
        'connect' => true,
        'behaviour' => 'tap-drag',
        'tooltips' => true,
    ];

    public $da_range = [
        'min' => 1, // Targets handle 1 value
        'max' => 100 // Targets handle 2 value
    ];


    public $rd_options = [
        'start' => [
            0,
            100000
        ],
        'range' => [
            'min' =>  [1],
            'max' => [100000]
        ],
        'connect' => true,
        'behaviour' => 'tap-drag',
        'tooltips' => true,
    ];

    public $rd_range = [
        'min' => 1, // Targets handle 1 value
        'max' => 100000 // Targets handle 2 value
    ];

    public function render()
    {
        $sites = $this->view_sites();
        return view('livewire.admin.view-all-sites-livewire',compact("sites"));
    }

    public function export_csv()
    {
        $sites = $this->view_sites();
        $headings = ["Root Domain","DR","RD","Traffic",	"Email"	,"DA","Spam Score"	,"Website Niche","Main Category","Marked Sponsor","Grey Niche","GP Agreed Price",
            "NE Agreed Price","Country Source"	,"Sample post","Paypal id","skype","whatsapp","Total time","Href url","Website Status","FC GP","FC NE"];
        $arr = [];
        $arr[] = $headings;
        foreach ($sites as $site){
            $arr[] = [
                $site->root_domain,
                $site->dr,
                $site->rd,
                $site->traffic_source,
                $site->email,
                $site->da,
                $site->spam_score,
                $site->website_niche,
                $site->category,
                $site->marked_sponsor,
                $site->grey_niche,
                $site->gp_price,
                $site->niche_edit_price,
                $site->country_source,
                $site->sample_url,
                $site->paypal_id,
                $site->skype,
                $site->whatsapp,
                $site->total_time,
                $site->href_url,
                $site->website_status,
                $site->fc_gp,
                $site->fc_ne,
            ];
        }


        $csvFile = fopen('export.csv', 'w');

        foreach ($arr as $row) {
            fputcsv($csvFile, $row);
        }

        fclose($csvFile);

        $headers = ['Content-Type: text/csv','Content-Disposition: attachment; filename="export.csv"'];
//        header('Content-Type: text/csv');
//        header('Content-Disposition: attachment; filename="export.csv"');
//        readfile('export.csv');


        return response()->streamDownload(function (){
            readfile('export.csv');
        },"export.csv",$headers);
    }

    public function searchTraffic()
    {
        $this->traffic = "";
    }

    public function searchWithGpPrice()
    {
        $this->gp_price = "";
    }
    public function searchWithNichePrice()
    {
        $this->niche_price = "";
    }

    public function view_sites()
    {
        return NewSite::withCount("dupl")
            ->with("new_order_process_detail")
            ->where('dr','>=',$this->dr_range['min'])
            ->where('dr','<=',$this->dr_range['max'])
            ->where('da','>=',$this->da_range['min'])
            ->where('da','<=',$this->da_range['max'])
            ->where('rd','>=',$this->rd_range['min'])
            ->where('rd','<=',$this->rd_range['max'])
            ->when(!empty($this->fc),function ($query){
                if($this->fc == 'GP'){
                    $query->where('fc_gp','>',1);
                }else{
                    $query->where('fc_ne','>',1);
                }

            })
            ->when(!empty($this->traffic),function ($query){
                $r = explode("-",$this->traffic);
                $query->where(DB::raw('CAST(traffic_source AS DECIMAL(10, 2))'), '>=', $r[0])
                    ->when(is_numeric($r[1]),function ($q) use ($r){
                        $q->where(DB::raw('CAST(traffic_source AS DECIMAL(10, 2))'), '<=', $r[1]);
                    });

            })
            ->when(!empty($this->gp_price),function ($query){
                $r = explode("-",$this->gp_price);
                $query->where(DB::raw('CAST(gp_price AS DECIMAL(10, 2))'), '>=', $r[0])
                    ->when(is_numeric($r[1]),function ($q) use ($r){
                        $q->where(DB::raw('CAST(gp_price AS DECIMAL(10, 2))'), '<=', $r[1]);
                    });

            })
            ->when(!empty($this->niche_price),function ($query){
                $r = explode("-",$this->niche_price);
                $query->where(DB::raw('CAST(niche_edit_price AS DECIMAL(10, 2))'), '>=', $r[0])
                    ->when(is_numeric($r[1]),function ($q) use ($r){
                        $q->where(DB::raw('CAST(niche_edit_price AS DECIMAL(10, 2))'), '<=', $r[1]);
                    });

            })
            ->when(!empty($this->root_domain),function ($query){
                $query->where($this->column_name,'LIKE','%'.$this->root_domain.'%');
            })
            ->when(!empty($this->category),function ($query){
                $query->where('category','LIKE','%'.$this->category.'%');
            })
            ->when(!empty($this->website_niche),function ($query){
                $query->where('website_niche','LIKE','%'.$this->website_niche.'%');
            })


            ->when(!empty($this->traffic_start_range),function ($query){
                $query->where(DB::raw('CAST(traffic_source AS DECIMAL(10, 2))'), '>=', $this->traffic_start_range);
            })
            ->when(!empty($this->traffic_end_range),function ($query){
                $query->where(DB::raw('CAST(traffic_source AS DECIMAL(10, 2))'), '<=', $this->traffic_end_range);
            })
            ->when(!empty($this->gpprice_start_range),function ($query){
                $query->where(DB::raw('CAST(gp_price AS DECIMAL(10, 2))'), '>=', $this->gpprice_start_range);
            })
            ->when(!empty($this->gpprice_end_range),function ($query){
                $query->where(DB::raw('CAST(gp_price AS DECIMAL(10, 2))'), '<=', $this->gpprice_end_range);
            })
            ->when(!empty($this->nicheprice_start_range),function ($query){
                $query->where(DB::raw('CAST(niche_edit_price AS DECIMAL(10, 2))'), '>=', $this->nicheprice_start_range);
            })
            ->when(!empty($this->nicheprice_end_range),function ($query){
                $query->where(DB::raw('CAST(niche_edit_price AS DECIMAL(10, 2))'), '<=', $this->nicheprice_end_range);
            })
            ->when(Auth::user()->role == 'vendor',function ($query){
                $query->where('uploaded_user_id',Auth::id());
            })
            ->when($this->site_status != "",function ($query){
                $query->where('site_status',$this->site_status);
            })
            ->when($this->new_arrival != "",function ($query){
                $query->where('created_at', '>=', Carbon::now()->subDays(30));
            })
            ->where('bulk_upload_status',null)
            ->where('bulk_upload_id',null)
            ->where('delete_site',null)
            ->orderBy('root_domain','asc')
            ->paginate(50);
    }


    public function approvedSite($id)
    {
        try{
            $site= NewSite::with("uploaded_user")->findOrFail($id);
            $site->site_status = 1;
            $site->website_status = "Acceptable";
            $site->save();
            if($site->uploaded_user->email){
                Mail::to($site->uploaded_user->email)->send(new NewSiteAccept($site->root_domain));
            }
            session()->flash("success","Site Approved");
        }catch (Exception $exception){
            session()->flash("error",$exception->getMessage());
        }
    }

    public function rejectSite($id)
    {
        try{
            $site= NewSite::findOrFail($id);
            $site->site_status = 2;
            $site->save();
            session()->flash("success","Site Rejected");
        }catch (Exception $exception){
            session()->flash("error",$exception->getMessage());
        }
    }

    public function clearFc()
    {
//        dd("END");
        $this->fc = '';
    }


}
