<?php

namespace App\Http\Responses;

use Filament\Pages\Dashboard;
use Illuminate\Http\RedirectResponse;
use Livewire\Features\SupportRedirects\Redirector;
use Filament\Http\Responses\Auth\LoginResponse as BaseLoginResponse;

class LoginResponse extends BaseLoginResponse
{
    public function toResponse($request): RedirectResponse|Redirector
    {
        if (auth()->user()->role == 'admin') {
            return redirect()->to(Dashboard::getUrl(panel: 'admin'));
        }

        if (auth()->user()->role == 'manager') {
            return redirect()->to(Dashboard::getUrl(panel: 'manager'));
        }

        if (auth()->user()->role == 'team') {
            return redirect()->to(Dashboard::getUrl(panel: 'team'));
        }

        if (auth()->user()->role == 'writer') {
            return redirect()->to(Dashboard::getUrl(panel: 'writer'));
        }

        return parent::toResponse($request);
    }
}
