<?php

namespace App\Http\Controllers\Vendor;

use App\Harman\Vendor\VendorCheckBankSetup;
use App\Harman\Vendor\VendorCheckPaypalSetup;
use App\Harman\Vendor\VendorCheckWithDrawalRequestSent;
use App\Harman\Vendor\VendorWalletQuery;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Wallet;
use App\Models\WalletHistory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\BrowserKit\History;

class WalletController extends Controller
{
    public function index()
    {
        $wallet= Wallet::where('user_id',Auth::id())->first();
        $wallet_histories= WalletHistory::with("new_order_process_detail.new_order_process.new_order")->whereHas('wallet',function ($q){
            $q->where('user_id',Auth::id());
        })->orderBy('id','asc')->get();
//        return $wallet_histories;

        return view("vendor.wallets.index",compact("wallet","wallet_histories"));
    }

    public function withdraw_request(Request $request)
    {

//        return $histories;
        return view("vendor.wallets.withdraw_request");
    }

    public function request_withdrawal(Request $request)
    {
        $balance = vendor_balance();
        if( $balance == 0 ){
            return redirect()->back()->with("error","Balance 0");
        }

//        if( VendorCheckWithDrawalRequestSent::check() ){
//            return redirect()->back()->with("error","Request already sent");
//        }

        $this->validate($request,[
            "payment_method"    =>  "required"
        ]);
        $bank=false;
        $paypal= true;

        if( VendorCheckBankSetup::check() ){
            $bank= false;
        }else{
            $bank= true;
        }

        if( VendorCheckPaypalSetup::check() ){
            $paypal = false;
        }else{
            $paypal= true;
        }

        if( $request->payment_method == 'bank' ){
            if( !$bank ){
                return redirect()->back()->with("error","Please setup bank details for withdrawal");
            }
        }

        if( $request->payment_method == 'paypal' ){
            if( !$paypal ){
                return redirect()->back()->with("error","Please setup paypal details for withdrawal");
            }
        }

        try {
            $user= Auth::user();
            $user->withdrawal_request = 1;
            $user->withdrawal_method = $request->payment_method;
            $user->withdrawal_request_date = Carbon::now();
            $user->save();

            return redirect()->back()->with("success","Request Sent");
         }catch (\Exception $exception){
             return redirect()->back()->with("error",$exception->getMessage());
         }
    }
}
