<?php

namespace App\Http\Controllers\Vendor;

use App\Harman\Common\OrderDetailStatus;
use App\Harman\Helpers\FileUpload;
use App\Harman\Vendor\Site\CreateSiteStep1;
use App\Harman\Vendor\Site\CreateSiteStep2;
use App\Harman\Vendor\Site\CreateSiteStep3;
use App\Harman\Vendor\Site\CreateSiteStep4;
use App\Harman\Vendor\VendorCompletedTasksQuery;
use App\Harman\Vendor\VendorTasksInProcessQuery;
use App\Http\Controllers\Controller;
use App\Imports\NewSiteImport;
use App\Models\BulkUpload;
use App\Models\MasterType;
use App\Models\NewSite;
use App\Models\OrderDetail;
use App\Models\OrderHistory;
use App\Models\Site;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;

class SiteController extends Controller
{
    public function submitted_site()
    {
        $record= DB::table("sites")
            ->select("sites.name as site_name","email","domain_name","user_id","sites.created_at as site_created")
            ->join('site_multiples','sites.id','=','site_multiples.site_id')
            ->addSelect(["associate_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.associate_type_id")->limit(1) ])
            ->addSelect(["domain_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.domain_type_id")->limit(1) ])
            ->addSelect(["niche_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.niche_type_id")->limit(1) ])
            ->addSelect(["sponsor_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.sponsor_type_id")->limit(1) ])
            ->addSelect(["link_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.link_type_id")->limit(1) ])
            ->addSelect(["validity_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.validity_type_id")->limit(1) ])
            ->addSelect(["grey_niche_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.grey_niche_type_id")->limit(1) ])
            ->addSelect(["no_of_links"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.no_of_links_id")->limit(1) ])
            ->addSelect(["category_type"=>
                DB::table("site_multiples")
                    ->selectRaw("GROUP_CONCAT((select name from masters where masters.id = site_multiples.name limit 1)) as original_name")
                    ->whereColumn('site_multiples.site_id',"sites.id")
                    ->where('master_type_url_slug','category-type')
                    ->groupBy("site_id")->limit(1)])
            ->addSelect(["traffic_source"=>
                DB::table("site_multiples")
                    ->selectRaw("GROUP_CONCAT((select name from masters where masters.id = site_multiples.name limit 1)) as original_name")
                    ->whereColumn('site_multiples.site_id',"sites.id")
                    ->where('master_type_url_slug','traffic-source')
                    ->groupBy("site_id")->limit(1)])
            ->addSelect(["grey_niche"=>
                DB::table("site_multiples")
                    ->selectRaw("GROUP_CONCAT((select name from masters where masters.id = site_multiples.name limit 1)) as original_name")
                    ->whereColumn('site_multiples.site_id',"sites.id")
                    ->where('master_type_url_slug','grey-niche')
                    ->groupBy("site_id")->limit(1)])

            ->groupBy('site_name','email','domain_name','associate_type',"user_id",'domain_type','niche_type','sponsor_type','link_type','validity_type','grey_niche_type',
                'no_of_links','category_type','traffic_source','grey_niche',"site_created"
            )
            ->where('sites.user_id',Auth::id())->first();

        return view("vendor.site.submitted_site",compact("record"));
    }

    public function sites()
    {
//        return NewSite::withCount("dupl")->get();
        return view("vendor.site.sites");
    }

    public function view($id)
    {
        $record= NewSite::findOrFail($id);
        return view("vendor.site.view",compact("record"));
    }

    public function site_create(Request $request)
    {
        if( session()->has("code") ){
            $code= session()->get("code");
            $site= Site::with("site_multiple_category_type","site_multiple_traffic_source","site_multiple_grey_niche")->where('unique_code',$code)->first();
        }else{
            $code= Str::random(30).Auth::id().time();
            $site= null;
        }


        $step = "";
        if( $request->type == "step1" ){ $step = "step1"; }
        elseif( $request->type == "step2" ){ $step = "step2"; }
        elseif( $request->type == "step3" ){ $step = "step3"; }
        elseif( $request->type == "step4" ){ $step = "step4"; }
        else{ $step = "step1"; }

        if($site){
            if( $site->step1 == 1 && $site->step2 == null && $site->step3 == null && $site->step4 == null ){
                if( $request->type == 'step3' || $request->type == 'step4'){
                    return redirect()->route("vendor.site_create",["type"=>"step2"]);
                }
            }

            if( $site->step1 == 1 && $site->step2 == 1 && $site->step3 == null && $site->step4 == null ){
                if( $request->type == 'step4'){
                    return redirect()->route("vendor.site_create",["type"=>"step3"]);
                }
            }

        }else{
            if($request->type == 'step2' || $request->type == 'step3' || $request->type == 'step4'){
                return redirect()->route("vendor.site_create");
            }
        }


        $grey_niche_types= MasterType::with("masters")->where('url_slug','grey-niche-type')->first();
        $grey_niches= MasterType::with("masters")->where('url_slug','grey-niche')->first();
        return view("vendor.site.site_create",compact("step","grey_niches","grey_niche_types","code","site"));
    }


    public function site_store(Request $request)
    {
        $step = "";
        if( $request->type == "step1" ){ $step = "step1"; }
        elseif( $request->type == "step2" ){ $step = "step2"; }
        elseif( $request->type == "step3" ){ $step = "step3"; }
        elseif( $request->type == "step4" ){ $step = "step4"; }
        else{ $step = "step1"; }

        if( $step == "step1" ) {
            return (new CreateSiteStep1() )->create($request);
        }


        if( $step == "step2" ){
            $this->validate($request,[
                "associate_type"    =>  "required",
                "domain_type"    =>  "required",
                "domain_name"    =>  "required",
                "niche_type"    =>  "required",
                "category_type"    =>  "required",
                "traffic_source"    =>  "required",
                "word_count"    =>  "required",
                "sample_url"    =>  "required",
//                "site_description"    =>  "required",
//                "ownership_verification"    =>  "required",
            ]);

            return (new CreateSiteStep2())->create($request);


        }


        if( $step == "step3" ){
            $this->validate($request,[
                "sponsor_type"    =>  "required",
                "link_type"    =>  "required",
                "validity_type"    =>  "required",
                "grey_niche_type"    =>  "required",
            ]);


            return (new CreateSiteStep3() )->create($request);

        }


        if( $step == 'step4' ){
            $this->validate($request,[
                "da"    =>  "required",
                "traffic"    =>  "required",
                "gp"    =>  "required",
                "rd"    =>  "required",
                "niche_price"    =>  "required",
            ]);


            return (new CreateSiteStep4() )->create($request);


        }
    }

    public function tasks_in_process(Request $request)
    {
        $segment= $request->segment(2);

        if( $segment == 'completed-tasks' ){
            $orders= VendorCompletedTasksQuery::get();

        }elseif ( $segment == 'tasks-in-process' ){
            $orders= VendorTasksInProcessQuery::get();
        }

        return view("vendor.site.tasks_in_process",compact("orders"));
    }

    public function order_detail($id)
    {
        $order= OrderDetail::whereHas("site",function ($query){
            $query->where('user_id',Auth::id());
        })
            ->with(["order.team","order_histories"=>function($query){
                $query->where('status',OrderDetailStatus::$TEAM_APPROVED_VENDOR_PENDING)
                    ->orWhere('status',OrderDetailStatus::$VENDOR_APPROVED)
                    ->orWhere('status',OrderDetailStatus::$PROJECT_COMPLETED);
            },"order_histories.user"])
            ->where('id',$id)
            ->firstOrFail();
        return view("vendor.site.order_detail",compact("order"));
    }

    public function change_status(Request $request)
    {
        $this->validate($request,[
           "site_url"   =>  "required"
        ]);
        $order_detail= OrderDetail::with("order_histories")->findOrFail($request->order_detail_id);
         try {
             DB::beginTransaction();
             foreach ($order_detail->order_histories as $his){
                 $his->editable = 0;
                 $his->save();
             }

             $history= new OrderHistory();
             $history->order_detail_id= $request->order_detail_id;
             $history->user_id= Auth::id();
             $history->editable = 1;
             $history->site_url= $request->site_url;
             $history->status= OrderDetailStatus::$VENDOR_APPROVED;
             $history->save();

             $order_detail->status= OrderDetailStatus::$VENDOR_APPROVED;
             $order_detail->save();

            DB::commit();
            return redirect()->back();
         }catch (\Exception $exception){
             DB::rollBack();
             return redirect()->back()->with("error",$exception->getMessage());
         }
    }

    public function site_verification($id)
    {
        $site= Site::findOrFail($id);
        return view("vendor.site.verification",compact("site"));
    }


    public function upload_excel()
    {
        $bulk_upload_status= BulkUpload::where('vendor_id',Auth::id())
            ->where('status',0)
            ->orWhere('status',1)
            ->get();
        return view("vendor.site.upload_excel",compact("bulk_upload_status"));
    }

    public function upload_save_excel(Request $request)
    {
        $this->validate($request,[
           "upload_excel"   =>  "required|mimes:xlsx,csv"
        ]);

         try {
            $file= new FileUpload($request,"upload_excel","/excel");
            $filename= $file->upload();

            $bulk_upload= new BulkUpload();
            $bulk_upload->vendor_id= Auth::id();
            $bulk_upload->filename = $filename;
            $bulk_upload->status =0 ;
            $bulk_upload->save();

            return redirect()->back()->with("success","Successfully Uploaded");
         }catch (\Exception $exception){
             return redirect()->back()->with("error",$exception->getMessage());
         }

    }


    public function uploaded_sites($id)
    {
        $bulk_upload= BulkUpload::withCount("bulk_upload_sites")->where('vendor_id',Auth::id())
            ->where('status',1)
            ->where('id',$id)
            ->firstOrFail();



        return view("vendor.site.uploaded_sites",compact("bulk_upload"));
    }


}
