<?php

namespace App\Http\Controllers\Vendor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    public function setup_payment_method()
    {
       return view("vendor.payment.setup_payment_method");
    }

    public function setup_paypal()
    {
        return view("vendor.payment.setup_paypal");
    }

    public function setup_paypal_store(Request $request)
    {
        $request->validate([
           "paypal_email"  =>  "required|email:rfc,dns"
        ]);

         try {
            $user= auth()->user();
            if( $user->paypal_email == "" ){
                $user->paypal_email= $request->paypal_email;
                $user->save();

                return redirect()->back()->with("success","Paypal Email Saved");
            }else{
                return redirect()->back();
            }

         }catch (\Exception $exception){
             return redirect()->back()->with("error",$exception->getMessage());
         }

    }

}
