<?php

namespace App\Http\Controllers\Vendor;

use App\Harman\Helpers\FileProcess;
use App\Http\Controllers\Controller;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{

    public function payment_details()
    {
        return view("vendor.dashboard.payment_details");
    }
    public function view_profile()
    {
        return view("vendor.dashboard.view_profile");
    }
    public function new_design()
    {
        return view("vendor.dashboard.new_design");
    }
    public function index()
    {
        $pending_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER,NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])->count();
        $completed_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED])->count();
        return view("vendor.dashboard.index",compact("pending_orders","completed_orders"));
    }

    public function profile()
    {
        return view("vendor.dashboard.profile");
    }

    public function update_profile(Request $request)
    {
        $this->validate($request,[
           "name"   =>  "required",
           "profile"    =>  "nullable|image"
        ]);

        try{
            $u= Auth::user();
            $u->name = $request->name;
            $u->whatsapp = $request->whatsapp;
            $u->skype = $request->skype;
            $u->country_id = $request->country_id;

            if( $request->hasFile("profile") ){
                $f = new FileProcess();
                $f->init("uploads", $request->profile);
                $f->unique("users", "profile_image");
                $f->prefix("avatar_");
                $filename = $f->upload();
//                dd($filename);
                $u->profile_image = $filename;
            }

            $u->save();

            return redirect()->route("vendor.view_profile")->with("success","Profile Updated");
        }catch (\Exception $exception){
            return redirect()->back()->with("error",$exception->getMessage());
        }



    }

}
