<?php

namespace App\Http\Controllers\Vendor;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BankController extends Controller
{
    public function bank_details()
    {
        return view("vendor.bank.index");
    }

    public function update_bank_details(Request $request)
    {
        $request->validate($request,[
            "ac_holder_name" =>  "required",
            "bank_name" =>  "required",
            "account_number" =>  "required",
            "bank_address" =>  "required",
            "swift_code" =>  "required",
        ]);


        try {

            $user= User::find(Auth::id());
            $user->ac_holder_name= $request->ac_holder_name;
            $user->bank_name= $request->bank_name;
            $user->account_number= $request->account_number;
            $user->bank_address= $request->bank_address;
            $user->swift_code= $request->swift_code;
            $user->save();

            return redirect()->back()->with("success","Bank Details Updated");
        }catch (\Exception $exception){
            return redirect()->back()->with("error",$exception->getMessage());
        }
    }
}
